/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import org.apache.camel.Processor;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConsumer
extends DefaultConsumer<JmsExchange> {
    private final AbstractMessageListenerContainer listenerContainer;
    private EndpointMessageListener messageListener;

    public JmsConsumer(JmsEndpoint endpoint, Processor processor, AbstractMessageListenerContainer listenerContainer) {
        super(endpoint, processor);
        this.listenerContainer = listenerContainer;
        this.createMessageListener(endpoint, processor);
        this.listenerContainer.setMessageListener((Object)this.messageListener);
    }

    public AbstractMessageListenerContainer getListenerContainer() {
        return this.listenerContainer;
    }

    public EndpointMessageListener getEndpointMessageListener() {
        return this.messageListener;
    }

    protected void createMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.messageListener = new EndpointMessageListener(endpoint, processor);
        this.messageListener.setBinding(endpoint.getBinding());
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.listenerContainer.afterPropertiesSet();
        this.listenerContainer.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.listenerContainer.stop();
        this.listenerContainer.destroy();
        super.doStop();
    }
}

