/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.NIOConverter;

@Converter
public final class JmsIOConverter {
    private JmsIOConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static ByteBuffer toByteBuffer(Message message, Exchange exchange) throws Exception {
        if (message instanceof TextMessage) {
            String text = ((TextMessage)message).getText();
            return NIOConverter.toByteBuffer(text, exchange);
        }
        if (message instanceof BytesMessage) {
            BytesMessage bmsg = (BytesMessage)message;
            int len = (int)bmsg.getBodyLength();
            byte[] data = new byte[len];
            bmsg.readBytes(data, len);
            return NIOConverter.toByteBuffer(data);
        }
        if (message instanceof StreamMessage) {
            StreamMessage msg = (StreamMessage)message;
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            try {
                try {
                    while (true) {
                        Object obj = msg.readObject();
                        JmsIOConverter.writeData(dataOut, obj);
                    }
                }
                catch (MessageEOFException e) {
                    dataOut.close();
                }
            }
            catch (Throwable throwable) {
                dataOut.close();
                throw throwable;
            }
            return NIOConverter.toByteBuffer(bytesOut.toByteArray());
        }
        if (message instanceof MapMessage) {
            MapMessage msg = (MapMessage)message;
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            Enumeration en = msg.getMapNames();
            while (en.hasMoreElements()) {
                Object obj = msg.getObject(en.nextElement().toString());
                JmsIOConverter.writeData(dataOut, obj);
            }
            dataOut.close();
            return NIOConverter.toByteBuffer(bytesOut.toByteArray());
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objMessage = (ObjectMessage)message;
            Serializable object = objMessage.getObject();
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
            objectOut.writeObject(object);
            objectOut.close();
            return NIOConverter.toByteBuffer(bytesOut.toByteArray());
        }
        return null;
    }

    private static void writeData(DataOutputStream dataOut, Object data) throws Exception {
        if (data instanceof byte[]) {
            dataOut.write((byte[])data);
        } else if (data instanceof String) {
            dataOut.writeUTF(data.toString());
        } else if (data instanceof Double) {
            dataOut.writeDouble((Double)data);
        } else if (data instanceof Float) {
            dataOut.writeFloat(((Float)data).floatValue());
        } else if (data instanceof Long) {
            dataOut.writeLong((Long)data);
        } else if (data instanceof Integer) {
            dataOut.writeInt((Integer)data);
        } else if (data instanceof Short) {
            dataOut.writeShort(((Short)data).shortValue());
        } else if (data instanceof Character) {
            dataOut.writeChar(((Character)data).charValue());
        } else if (data instanceof Byte) {
            dataOut.writeByte(((Byte)data).byteValue());
        } else if (data instanceof Boolean) {
            dataOut.writeBoolean((Boolean)data);
        }
    }
}

