/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.impl.PollingConsumerSupport;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.JmsTemplate102;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsPollingConsumer
extends PollingConsumerSupport<JmsExchange> {
    private JmsOperations template;

    public JmsPollingConsumer(JmsEndpoint endpoint, JmsOperations template) {
        super(endpoint);
        this.template = template;
    }

    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    @Override
    public JmsExchange receiveNoWait() {
        return this.receive(0L);
    }

    @Override
    public JmsExchange receive() {
        return this.receive(-1L);
    }

    @Override
    public JmsExchange receive(long timeout) {
        this.setReceiveTimeout(timeout);
        Message message = this.template.receive();
        if (message != null) {
            return this.getEndpoint().createExchange(message);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    protected void setReceiveTimeout(long timeout) {
        if (this.template instanceof JmsTemplate) {
            JmsTemplate jmsTemplate = (JmsTemplate)this.template;
            jmsTemplate.setReceiveTimeout(timeout);
        } else if (this.template instanceof JmsTemplate102) {
            JmsTemplate102 jmsTemplate102 = (JmsTemplate102)this.template;
            jmsTemplate102.setReceiveTimeout(timeout);
        } else {
            throw new IllegalArgumentException("Cannot set the receiveTimeout property on unknown JmsOperations type: " + this.template);
        }
    }
}

