/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.camel.Processor;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailConsumer
extends ScheduledPollConsumer<MailExchange> {
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    private static final transient Log LOG = LogFactory.getLog(MailConsumer.class);
    private final MailEndpoint endpoint;
    private final JavaMailSenderImpl sender;
    private Folder folder;
    private Store store;

    public MailConsumer(MailEndpoint endpoint, Processor processor, JavaMailSenderImpl sender) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.sender = sender;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void poll() throws Exception {
        this.ensureIsConnected();
        if (this.store == null || this.folder == null) {
            throw new IllegalStateException("MailConsumer did not connect properly to the MailStore: " + this.endpoint.getConfiguration().getMailStoreLogInformation());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Polling mailfolder: " + this.endpoint.getConfiguration().getMailStoreLogInformation()));
        }
        if (this.endpoint.getConfiguration().getFetchSize() == 0) {
            LOG.warn((Object)"Fetch size is 0 meaning the configuration is set to poll no new messages at all. Camel will skip this poll.");
            return;
        }
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
        try {
            int count = this.folder.getMessageCount();
            if (count > 0) {
                Message[] messages = this.endpoint.getConfiguration().isProcessOnlyUnseenMessages() ? this.folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false)) : this.folder.getMessages();
                this.processMessages(messages);
            } else if (count == -1) {
                throw new MessagingException("Folder: " + this.folder.getFullName() + " is closed");
            }
        }
        finally {
            try {
                if (this.folder.isOpen()) {
                    this.folder.close(true);
                }
            }
            catch (MessagingException e) {
                LOG.debug((Object)("Could not close mailbox folder: " + this.folder.getName()), (Throwable)e);
            }
        }
    }

    protected void ensureIsConnected() throws MessagingException {
        MailConfiguration config = this.endpoint.getConfiguration();
        if (this.store == null || !this.store.isConnected()) {
            this.store = this.sender.getSession().getStore(config.getProtocol());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connecting to MailStore " + this.endpoint.getConfiguration().getMailStoreLogInformation()));
            }
            this.store.connect(config.getHost(), config.getPort(), config.getUsername(), config.getPassword());
        }
        if (this.folder == null) {
            this.folder = this.store.getFolder(config.getFolderName());
            if (this.folder == null || !this.folder.exists()) {
                throw new FolderNotFoundException(this.folder, "Folder not found or invalid: " + config.getFolderName());
            }
        }
    }

    protected void processMessages(Message[] messages) throws Exception {
        int count;
        int fetchSize = this.endpoint.getConfiguration().getFetchSize();
        int n = count = fetchSize == -1 ? messages.length : Math.min(fetchSize, messages.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching " + count + " messages. Total " + messages.length + " messages."));
        }
        for (int i = 0; i < count; ++i) {
            Message message = messages[i];
            if (!message.getFlags().contains(Flags.Flag.DELETED)) {
                this.processMessage(message);
                this.flagMessageProcessed(message);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping message as it was flagged as deleted: " + MailUtils.dumpMessage(message)));
        }
    }

    protected void processMessage(Message message) throws Exception {
        MailExchange exchange = this.endpoint.createExchange(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing message: " + MailUtils.dumpMessage(message)));
        }
        this.getProcessor().process(exchange);
    }

    protected void flagMessageProcessed(Message message) throws MessagingException {
        if (this.endpoint.getConfiguration().isDeleteProcessedMessages()) {
            message.setFlag(Flags.Flag.DELETED, true);
        } else {
            message.setFlag(Flags.Flag.SEEN, true);
        }
    }
}

