/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Exchange;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailProducer
extends DefaultProducer<MailExchange> {
    private static final transient Log LOG = LogFactory.getLog(MailProducer.class);
    private final MailEndpoint endpoint;
    private final JavaMailSender sender;

    public MailProducer(MailEndpoint endpoint, JavaMailSender sender) {
        super(endpoint);
        this.endpoint = endpoint;
        this.sender = sender;
    }

    @Override
    public void process(final Exchange exchange) {
        this.sender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MailProducer.this.endpoint.getBinding().populateMailMessage(MailProducer.this.endpoint, mimeMessage, exchange);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending MimeMessage: " + MailUtils.dumpMessage((Message)mimeMessage)));
                }
            }
        });
    }
}

