/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.TextLineCodecFactory;
import org.apache.camel.component.mina.TextLineDelimiter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaComponent
extends DefaultComponent<MinaExchange> {
    private static final transient Log LOG = LogFactory.getLog(MinaComponent.class);
    private MinaConfiguration configuration;

    public MinaComponent() {
    }

    public MinaComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint<MinaExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating MinaEndpoint from uri: " + uri));
        }
        MinaConfiguration config = this.configuration != null ? this.configuration.copy() : new MinaConfiguration();
        URI u = new URI(remaining);
        config.setHost(u.getHost());
        config.setPort(u.getPort());
        config.setProtocol(u.getScheme());
        this.setProperties(config, parameters);
        return this.createEndpoint(uri, config);
    }

    public Endpoint createEndpoint(MinaConfiguration config) throws Exception {
        return this.createEndpoint(null, config);
    }

    private Endpoint createEndpoint(String uri, MinaConfiguration config) throws Exception {
        String protocol = config.getProtocol();
        if (protocol != null) {
            if (protocol.equals("tcp")) {
                return this.createSocketEndpoint(uri, config);
            }
            if (protocol.equals("udp") || protocol.equals("mcast") || protocol.equals("multicast")) {
                return this.createDatagramEndpoint(uri, config);
            }
            if (protocol.equals("vm")) {
                return this.createVmEndpoint(uri, config);
            }
        }
        throw new IllegalArgumentException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
    }

    protected MinaEndpoint createVmEndpoint(String uri, MinaConfiguration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        boolean sync = configuration.isSync();
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        VmPipeAddress address = new VmPipeAddress(configuration.getPort());
        VmPipeConnector connector = new VmPipeConnector();
        this.configureCodecFactory("MinaProducer", connector.getDefaultConfig(), configuration);
        if (minaLogger) {
            connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.configureCodecFactory("MinaConsumer", acceptor.getDefaultConfig(), configuration);
        if (minaLogger) {
            acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this);
        endpoint.setAddress((SocketAddress)address);
        endpoint.setAcceptor((IoAcceptor)acceptor);
        endpoint.setConnector((IoConnector)connector);
        endpoint.setConfiguration(configuration);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected MinaEndpoint createSocketEndpoint(String uri, MinaConfiguration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        long timeout = configuration.getTimeout();
        boolean sync = configuration.isSync();
        ExecutorService executor = Executors.newCachedThreadPool();
        SocketAcceptor acceptor = new SocketAcceptor(Runtime.getRuntime().availableProcessors() + 1, (Executor)executor);
        acceptor.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        InetSocketAddress address = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        SocketConnector connector = new SocketConnector();
        SocketConnectorConfig connectorConfig = new SocketConnectorConfig();
        this.configureCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, configuration);
        if (minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        connectorConfig.setConnectTimeout((int)(timeout / 1000L));
        SocketAcceptorConfig acceptorConfig = new SocketAcceptorConfig();
        this.configureCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, configuration);
        acceptorConfig.setReuseAddress(true);
        acceptorConfig.setDisconnectOnUnbind(true);
        if (minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this);
        endpoint.setAddress(address);
        endpoint.setAcceptor((IoAcceptor)acceptor);
        endpoint.setAcceptorConfig((IoAcceptorConfig)acceptorConfig);
        endpoint.setConnector((IoConnector)connector);
        endpoint.setConnectorConfig((IoConnectorConfig)connectorConfig);
        endpoint.setConfiguration(configuration);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected void configureCodecFactory(String type, IoServiceConfig config, MinaConfiguration configuration) {
        ProtocolCodecFactory codecFactory = this.getCodecFactory(type, configuration.getCodec());
        if (codecFactory == null) {
            if (configuration.isTextline()) {
                Charset charset = MinaComponent.getEncodingParameter(type, configuration);
                LineDelimiter delimiter = MinaComponent.getLineDelimiterParameter(configuration.getTextlineDelimiter());
                codecFactory = new TextLineCodecFactory(charset, delimiter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(type + ": Using TextLineCodecFactory: " + codecFactory + " using encoding: " + charset + " and line delimiter: " + (Object)((Object)configuration.getTextlineDelimiter()) + "(" + delimiter + ")"));
                }
            } else {
                codecFactory = new ObjectSerializationCodecFactory();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(type + ": Using ObjectSerializationCodecFactory: " + codecFactory));
                }
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    protected MinaEndpoint createDatagramEndpoint(String uri, MinaConfiguration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        long timeout = configuration.getTimeout();
        boolean transferExchange = configuration.isTransferExchange();
        boolean sync = configuration.isSync();
        DatagramAcceptor acceptor = new DatagramAcceptor();
        InetSocketAddress address = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        DatagramConnector connector = new DatagramConnector();
        if (transferExchange) {
            throw new IllegalArgumentException("transferExchange=true is not supported for datagram protocol");
        }
        DatagramConnectorConfig connectorConfig = new DatagramConnectorConfig();
        this.configureDataGramCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, configuration);
        if (minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        connectorConfig.setConnectTimeout((int)(timeout / 1000L));
        DatagramAcceptorConfig acceptorConfig = new DatagramAcceptorConfig();
        this.configureDataGramCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, configuration);
        acceptorConfig.setDisconnectOnUnbind(true);
        if (minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        MinaEndpoint endpoint = new MinaEndpoint(uri, this);
        endpoint.setAddress(address);
        endpoint.setAcceptor((IoAcceptor)acceptor);
        endpoint.setAcceptorConfig((IoAcceptorConfig)acceptorConfig);
        endpoint.setConnector((IoConnector)connector);
        endpoint.setConnectorConfig((IoConnectorConfig)connectorConfig);
        endpoint.setConfiguration(configuration);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected void configureDataGramCodecFactory(String type, IoServiceConfig config, MinaConfiguration configuration) {
        ProtocolCodecFactory codecFactory = this.getCodecFactory(type, configuration.getCodec());
        if (codecFactory == null) {
            final Charset charset = MinaComponent.getEncodingParameter(type, configuration);
            codecFactory = new ProtocolCodecFactory(){

                public ProtocolEncoder getEncoder() throws Exception {
                    return new ProtocolEncoder(){
                        private CharsetEncoder encoder;

                        public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                            if (this.encoder == null) {
                                this.encoder = charset.newEncoder();
                            }
                            ByteBuffer buf = MinaComponent.this.toByteBuffer(message, this.encoder);
                            buf.flip();
                            out.write(buf);
                        }

                        public void dispose(IoSession session) throws Exception {
                        }
                    };
                }

                public ProtocolDecoder getDecoder() throws Exception {
                    return new ProtocolDecoder(){

                        public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
                            in.acquire();
                            out.write((Object)in);
                        }

                        public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
                        }

                        public void dispose(IoSession session) throws Exception {
                        }
                    };
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": Using CodecFactory: " + codecFactory + " using encoding: " + charset));
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    private ByteBuffer toByteBuffer(Object message, CharsetEncoder encoder) throws CharacterCodingException {
        ByteBuffer answer;
        try {
            answer = this.convertTo(ByteBuffer.class, message);
        }
        catch (NoTypeConversionAvailableException e) {
            String value = this.convertTo(String.class, message);
            answer = ByteBuffer.allocate((int)value.length()).setAutoExpand(true);
            answer.putString((CharSequence)value, encoder);
        }
        return answer;
    }

    private ProtocolCodecFactory getCodecFactory(String type, String codec) {
        ProtocolCodecFactory codecFactory = null;
        if (codec != null) {
            codecFactory = this.getCamelContext().getRegistry().lookup(codec, ProtocolCodecFactory.class);
            if (codecFactory == null) {
                throw new IllegalArgumentException("Codec " + codec + " not found in registry.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": Using custom CodecFactory: " + codecFactory));
            }
        }
        return codecFactory;
    }

    private void addCodecFactory(IoServiceConfig config, ProtocolCodecFactory codecFactory) {
        config.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }

    private static LineDelimiter getLineDelimiterParameter(TextLineDelimiter delimiter) {
        if (delimiter == null) {
            return LineDelimiter.DEFAULT;
        }
        switch (delimiter) {
            case DEFAULT: {
                return LineDelimiter.DEFAULT;
            }
            case AUTO: {
                return LineDelimiter.AUTO;
            }
            case UNIX: {
                return LineDelimiter.UNIX;
            }
            case WINDOWS: {
                return LineDelimiter.WINDOWS;
            }
            case MAC: {
                return LineDelimiter.MAC;
            }
        }
        throw new IllegalArgumentException("Unknown textline delimiter: " + (Object)((Object)delimiter));
    }

    private static Charset getEncodingParameter(String type, MinaConfiguration configuration) {
        String encoding = configuration.getEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            configuration.setEncoding(encoding);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + ": No encoding parameter using default charset: " + encoding));
            }
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    public MinaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinaConfiguration configuration) {
        this.configuration = configuration;
    }
}

