/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class RestletConsumer
extends DefaultConsumer {
    private static final Log LOG = LogFactory.getLog(RestletConsumer.class);
    private Restlet restlet = new Restlet(){

        public void handle(Request request, Response response) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Consumer restlet handle request method: " + request.getMethod()));
            }
            try {
                Object exchange = RestletConsumer.this.getEndpoint().createExchange();
                RestletBinding binding = ((RestletEndpoint)RestletConsumer.this.getEndpoint()).getRestletBinding();
                binding.populateExchangeFromRestletRequest(request, (Exchange)exchange);
                RestletConsumer.this.getProcessor().process((Exchange)exchange);
                binding.populateRestletResponseFromExchange((Exchange)exchange, response);
            }
            catch (Exception e) {
                throw new RuntimeCamelException(e);
            }
        }
    };

    public RestletConsumer(Endpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ((RestletEndpoint)this.getEndpoint()).connect(this);
    }

    public void doStop() throws Exception {
        ((RestletEndpoint)this.getEndpoint()).disconnect(this);
        super.doStop();
    }

    public Restlet getRestlet() {
        return this.restlet;
    }
}

