/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import java.util.HashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.component.spring.integration.SpringIntegrationExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.BeanFactoryChannelResolver;
import org.springframework.integration.channel.ChannelResolver;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringIntegrationProducer
extends DefaultProducer<SpringIntegrationExchange>
implements AsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(SpringIntegrationProducer.class);
    private SpringCamelContext context;
    private DirectChannel inputChannel;
    private MessageChannel outputChannel;
    private String outputChannelName;
    private ChannelResolver channelResolver;
    private SpringIntegrationEndpoint endpoint;

    public SpringIntegrationProducer(SpringIntegrationEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
        this.context = (SpringCamelContext)endpoint.getCamelContext();
        if (this.context != null && endpoint.getMessageChannel() == null) {
            this.outputChannelName = endpoint.getDefaultChannel();
            this.channelResolver = new BeanFactoryChannelResolver((BeanFactory)this.context.getApplicationContext());
            if (ObjectHelper.isNullOrBlank(this.outputChannelName)) {
                this.outputChannelName = endpoint.getInputChannel();
            }
            if (ObjectHelper.isNullOrBlank(this.outputChannelName)) {
                throw new RuntimeCamelException("Can't find the right outputChannelName, please check the endpoint uri outputChannel part!");
            }
            this.outputChannel = this.channelResolver.resolveChannelName(this.outputChannelName);
        } else if (endpoint.getMessageChannel() != null) {
            this.outputChannel = endpoint.getMessageChannel();
        } else {
            throw new RuntimeCamelException("Can't find the right message channel, please check your configuration.");
        }
        if (endpoint.isInOut()) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
            if (ObjectHelper.isNullOrBlank(endpoint.getInputChannel())) {
                throw new RuntimeCamelException("Can't find the right inputChannel, please check the endpoint uri inputChannel part!");
            }
            this.inputChannel = (DirectChannel)this.channelResolver.resolveChannelName(endpoint.getInputChannel());
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (exchange.getPattern().isOutCapable()) {
            headers.put("springintegration_replyChannel", this.inputChannel);
            this.inputChannel.subscribe(new MessageHandler(){

                public void handleMessage(Message<?> message) {
                    SpringIntegrationBinding.storeToCamelMessage(message, exchange.getOut());
                    callback.done(true);
                }
            });
        }
        Message siOutmessage = SpringIntegrationBinding.createSpringIntegrationMessage(exchange, headers);
        this.outputChannel.send(siOutmessage);
        if (!exchange.getPattern().isOutCapable()) {
            callback.done(true);
        }
        return true;
    }
}

