/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.adapter;

import java.util.HashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.adapter.AbstractCamelAdapter;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.MessageHandler;

public class CamelSourceAdapter
extends AbstractCamelAdapter
implements InitializingBean {
    protected final Object lifecycleMonitor = new Object();
    private final Log logger = LogFactory.getLog(this.getClass());
    private Consumer consumer;
    private Endpoint camelEndpoint;
    private MessageChannel requestChannel;
    private DirectChannel replyChannel;
    private volatile boolean initialized;

    public void setRequestChannel(MessageChannel channel) {
        this.requestChannel = channel;
    }

    public MessageChannel getChannel() {
        return this.requestChannel;
    }

    public void setReplyChannel(DirectChannel channel) {
        this.replyChannel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterPropertiesSet() throws Exception {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
        }
        this.initialize();
        this.initialized = true;
    }

    protected void initialize() throws Exception {
        this.camelEndpoint = this.getCamelContext().getEndpoint(this.getCamelEndpointUri());
        this.consumer = this.camelEndpoint.createConsumer(new ConsumerProcessor());
        this.consumer.start();
    }

    protected class ConsumerProcessor
    implements AsyncProcessor {
        protected ConsumerProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            AsyncProcessorHelper.process(this, exchange);
        }

        public boolean process(final Exchange exchange, final AsyncCallback callback) {
            Message request = SpringIntegrationBinding.createSpringIntegrationMessage(exchange);
            HashMap<String, DirectChannel> headers = new HashMap<String, DirectChannel>();
            if (exchange.getPattern().isOutCapable()) {
                headers.put("springintegration_replyChannel", CamelSourceAdapter.this.replyChannel);
                CamelSourceAdapter.this.replyChannel.subscribe(new MessageHandler(){

                    public void handleMessage(Message<?> message) {
                        SpringIntegrationBinding.storeToCamelMessage(message, exchange.getOut());
                        callback.done(true);
                    }
                });
            }
            CamelSourceAdapter.this.requestChannel.send(request);
            if (!exchange.getPattern().isOutCapable()) {
                callback.done(true);
            }
            return true;
        }
    }
}

