/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamConsumer
extends DefaultConsumer<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(StreamConsumer.class);
    private static final String TYPES = "in,file,url";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{in,file,url}'";
    private static final List<String> TYPES_LIST = Arrays.asList("in,file,url".split(","));
    private InputStream inputStream = System.in;
    private StreamEndpoint endpoint;
    private String uri;

    public StreamConsumer(StreamEndpoint endpoint, Processor processor, String uri) throws Exception {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.uri = uri;
        this.validateUri(uri);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if ("in".equals(this.uri)) {
            this.inputStream = System.in;
        } else if ("file".equals(this.uri)) {
            this.inputStream = this.resolveStreamFromFile();
        } else if ("url".equals(this.uri)) {
            this.inputStream = this.resolveStreamFromUrl();
        }
        this.readFromStream();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
    }

    private void readFromStream() throws Exception {
        String line;
        Charset charset = this.endpoint.getCharset();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, charset));
        while ((line = br.readLine()) != null) {
            this.consumeLine(line);
        }
    }

    private void consumeLine(Object line) throws Exception {
        Object exchange = this.endpoint.createExchange();
        DefaultMessage msg = new DefaultMessage();
        msg.setBody(line);
        exchange.setIn(msg);
        this.getProcessor().process((Exchange)exchange);
    }

    private InputStream resolveStreamFromUrl() throws IOException {
        String u = this.endpoint.getUrl();
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getInputStream();
    }

    private InputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFile() != null ? this.endpoint.getFile().trim() : "_file";
        File f = new File(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to read from file: " + f));
        }
        f.createNewFile();
        return new FileInputStream(f);
    }

    private void validateUri(String uri) throws IllegalArgumentException {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

