/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.uface;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DelegateLifecycleStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.ufacekit.model.ModelHelper;
import org.ufacekit.ui.AttributeDescriptor;
import org.ufacekit.ui.UIComposite;
import org.ufacekit.ui.UIFactory;
import org.ufacekit.ui.beanform.BeanForm;
import org.ufacekit.ui.controls.CellLabelProvider;
import org.ufacekit.ui.controls.UIFormControl;
import org.ufacekit.ui.controls.UITable;
import org.ufacekit.ui.controls.UITableColumn;
import org.ufacekit.ui.layouts.GridLayoutData;
import org.ufacekit.ui.layouts.UILayoutData;

public class UFaceBrowser {
    private final DefaultCamelContext camelContext;
    private IObservableList endpoints;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public UFaceBrowser(DefaultCamelContext camelContext) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
        this.endpoints = new WritableList(Realm.getDefault());
        List<BrowsableEndpoint> list = CamelContextHelper.getSingletonEndpoints(camelContext, BrowsableEndpoint.class);
        for (BrowsableEndpoint endpoint : list) {
            if (this.endpoints.contains((Object)endpoint)) continue;
            this.endpoints.add((Object)endpoint);
        }
        camelContext.setLifecycleStrategy(new DelegateLifecycleStrategy(camelContext.getLifecycleStrategy()){

            @Override
            public void onEndpointAdd(Endpoint<? extends Exchange> endpoint) {
                super.onEndpointAdd(endpoint);
                if (endpoint instanceof BrowsableEndpoint) {
                    UFaceBrowser.this.onBrowsableEndpoint((BrowsableEndpoint)endpoint);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public IObservableList getEndpoints() {
        return this.endpoints;
    }

    public DefaultCamelContext getCamelContext() {
        return this.camelContext;
    }

    public void createBrowserUI(UIComposite root) {
        UIFactory ui = root.getFactory();
        UIComposite splitter = ui.newHorizontalSplitPanel(root, (UILayoutData)new GridLayoutData(4, 4));
        UITable tree = this.createEndpointTableUI(splitter);
        BeanForm selectionForm = new BeanForm();
        UITable table = ui.newTable(splitter, new UITable.TableUIInfo((UILayoutData)new GridLayoutData(1, 1, true, true)));
        selectionForm.add((UIFormControl)table, (UIFormControl.BindingInfo)new UITable.TableBindingInfo(selectionForm.detailList("exchanges", Collection.class)));
        ui.newTableColumn(table, new UITableColumn.TableColumnUIInfo(null, new CellLabelProvider(){

            public String getLabel(Object object) {
                Exchange exchange = (Exchange)object;
                return exchange.getIn().getBody(String.class);
            }
        }));
        ui.newTableColumn(table, new UITableColumn.TableColumnUIInfo(null, new CellLabelProvider(){

            public String getLabel(Object object) {
                Exchange exchange = (Exchange)object;
                return exchange.getIn().getHeaders().toString();
            }
        }));
        selectionForm.bind(tree.getSelectionObservable());
    }

    protected UITable createEndpointTableUI(UIComposite root) {
        BeanForm form = new BeanForm();
        UIFactory ui = root.getFactory();
        AttributeDescriptor bindingData = form.detailList("endpoints", Collection.class);
        UITable table = ui.newTable(root, new UITable.TableUIInfo(null));
        form.add((UIFormControl)table, (UIFormControl.BindingInfo)new UITable.TableBindingInfo(bindingData));
        ui.newTableColumn(table, new UITableColumn.TableColumnUIInfo(null, new CellLabelProvider(){

            public String getLabel(Object object) {
                BrowsableEndpoint endpoint = (BrowsableEndpoint)object;
                return endpoint.getEndpointUri();
            }
        }));
        WritableValue value = ModelHelper.createWritableValue((Object)this);
        form.bind((IObservableValue)value);
        return table;
    }

    protected void onBrowsableEndpoint(BrowsableEndpoint endpoint) {
        this.endpoints.add((Object)endpoint);
    }
}

