/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppConsumer
extends DefaultConsumer<XmppExchange>
implements PacketListener,
MessageListener {
    private static final transient Log LOG = LogFactory.getLog(XmppConsumer.class);
    private final XmppEndpoint endpoint;
    private Chat privateChat;
    private MultiUserChat muc;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.endpoint.getRoom() == null) {
            this.privateChat = this.endpoint.getConnection().getChatManager().createChat(this.endpoint.getParticipant(), (MessageListener)this);
            LOG.info((Object)("Open chat to " + this.privateChat.getParticipant()));
        } else {
            this.muc = new MultiUserChat(this.endpoint.getConnection(), this.endpoint.resolveRoom());
            this.muc.addMessageListener((PacketListener)this);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.muc.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
            LOG.info((Object)("Joined room: " + this.muc.getRoom()));
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.muc != null) {
            this.muc.leave();
            this.muc = null;
        }
    }

    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recieved XMPP message: " + message.getBody()));
        }
        XmppExchange exchange = this.endpoint.createExchange(message);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while processing message", (Throwable)e);
        }
    }

    public void processMessage(Chat chat, Message message) {
        this.processPacket((Packet)message);
    }
}

