/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.Map;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltComponent
extends ResourceBasedComponent {
    private XmlConverter xmlConverter;

    public XmlConverter getXmlConverter() {
        return this.xmlConverter;
    }

    public void setXmlConverter(XmlConverter xmlConverter) {
        this.xmlConverter = xmlConverter;
    }

    @Override
    protected Endpoint<Exchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String transformerFactoryName;
        Resource resource = this.resolveMandatoryResource(remaining);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this + " using schema resource: " + resource));
        }
        XsltBuilder xslt = this.newInstance(XsltBuilder.class);
        XmlConverter converter = null;
        String converterName = this.getAndRemoveParameter(parameters, "converter", String.class);
        if (converterName != null) {
            converter = this.mandatoryLookup(converterName, XmlConverter.class);
        }
        if (converter == null) {
            converter = this.getXmlConverter();
        }
        if (converter != null) {
            xslt.setConverter(converter);
        }
        String transformerFactoryClassName = this.getAndRemoveParameter(parameters, "transformerFactoryClass", String.class);
        TransformerFactory factory = null;
        if (transformerFactoryClassName != null) {
            Class<?> factoryClass = ObjectHelper.loadClass(transformerFactoryClassName);
            if (factoryClass != null) {
                factory = (TransformerFactory)this.newInstance(factoryClass);
            } else {
                this.log.warn((Object)("Can't find the TransformerFactoryClass with the class name " + transformerFactoryClassName));
            }
        }
        if ((transformerFactoryName = this.getAndRemoveParameter(parameters, "transformerFactory", String.class)) != null) {
            factory = this.mandatoryLookup(transformerFactoryName, TransformerFactory.class);
        }
        if (factory != null) {
            xslt.getConverter().setTransformerFactory(factory);
        }
        xslt.setTransformerInputStream(resource.getInputStream());
        this.configureXslt(xslt, uri, remaining, parameters);
        return new ProcessorEndpoint(uri, this, (Processor)xslt);
    }

    protected void configureXslt(XsltBuilder xslt, String uri, String remaining, Map parameters) throws Exception {
        this.setProperties(xslt, parameters);
    }
}

