/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fix;

import biz.c24.io.api.data.BooleanDataType;
import biz.c24.io.api.data.CharDataType;
import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.ComplexDataType;
import biz.c24.io.api.data.DataType;
import biz.c24.io.api.data.DateDataType;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.data.IntDataType;
import biz.c24.io.api.data.NumberDataType;
import biz.c24.io.api.data.StringDataType;
import biz.c24.io.api.presentation.TextualSource;
import biz.c24.io.fix42.NewOrderSingleElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.apache.camel.Converter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.ObjectConverter;
import quickfix.FieldMap;
import quickfix.Group;
import quickfix.Message;

@Converter
public final class FixConverter {
    private FixConverter() {
    }

    @Converter
    public static Message convert(ComplexDataObject cdo) {
        Message msg = new Message();
        FixConverter.convert(cdo, (FieldMap)msg);
        return msg;
    }

    @Converter
    public static ComplexDataObject convert(Message message) throws IOException {
        String text = message.toString();
        TextualSource src = new TextualSource((Reader)new StringReader(text));
        return src.readObject(NewOrderSingleElement.getInstance());
    }

    @Converter
    public static String toString(Message message) throws IOException {
        return message.toString();
    }

    @Converter
    public static InputStream toInputStream(Message message) throws IOException {
        return IOConverter.toInputStream(FixConverter.toString(message), null);
    }

    @Converter
    public static byte[] toByteArray(Message message) throws IOException {
        return ObjectConverter.toByteArray(FixConverter.toString(message));
    }

    @Converter
    public static Message convert(byte[] data) throws IOException {
        return FixConverter.convert(IOConverter.toInputStream(data));
    }

    @Converter
    public static Message convert(String data) throws IOException {
        return FixConverter.convert(IOConverter.toInputStream(data, null));
    }

    @Converter
    public static Message convert(URL data) throws IOException {
        return FixConverter.convert(IOConverter.toInputStream(data));
    }

    @Converter
    public static Message convert(BufferedReader reader) throws IOException {
        return FixConverter.convert(IOConverter.toInputStream(reader, null));
    }

    @Converter
    public static Message convert(File file) throws IOException {
        return FixConverter.convert(new FileInputStream(file));
    }

    @Converter
    public static Message convert(InputStream in) throws IOException {
        TextualSource src = new TextualSource(in);
        return FixConverter.convert(src.readObject(NewOrderSingleElement.getInstance()));
    }

    private static void convert(ComplexDataObject cdo, FieldMap fm) {
        int max = cdo.getElementDeclCount();
        for (int i = 0; i < max; ++i) {
            int tag;
            Element e = cdo.getElementDecl(i);
            DataType t = e.getType();
            Object value = cdo.getElement(e.getName());
            if (value == null) continue;
            int n = t.getName().startsWith("Field") ? FixConverter.tag(t) : (tag = cdo.getType().getName().startsWith("Field") ? FixConverter.tag((DataType)cdo.getType()) : 0);
            if (t instanceof ComplexDataType) {
                ComplexDataType ct = (ComplexDataType)t;
                if (ct.getName().startsWith("No") || ct.getName().endsWith("Header") || ct.getName().endsWith("Body") || ct.getName().endsWith("Trailer")) {
                    Element firstChild = ct.getElementDecl(0);
                    while (firstChild.getType() instanceof ComplexDataType && !firstChild.getType().getName().startsWith("Field")) {
                        firstChild = ((ComplexDataType)firstChild.getType()).getElementDecl(0);
                    }
                    if (fm instanceof Message && ct.getName().endsWith("Header")) {
                        FixConverter.convert((ComplexDataObject)value, (FieldMap)((Message)fm).getHeader());
                    }
                    if (fm instanceof Message && ct.getName().endsWith("Trailer")) {
                        FixConverter.convert((ComplexDataObject)value, (FieldMap)((Message)fm).getTrailer());
                        continue;
                    }
                    Group g = new Group(FixConverter.tag(firstChild.getType()), 0);
                    FixConverter.convert((ComplexDataObject)value, (FieldMap)g);
                    fm.addGroup(g);
                    continue;
                }
                FixConverter.convert((ComplexDataObject)cdo.getElement(e.getName()), fm);
                continue;
            }
            if (t instanceof BooleanDataType) {
                fm.setBoolean(tag, ((Boolean)value).booleanValue());
                continue;
            }
            if (t instanceof CharDataType) {
                fm.setChar(tag, ((Character)value).charValue());
                continue;
            }
            if (t instanceof IntDataType) {
                fm.setInt(tag, ((Integer)value).intValue());
                continue;
            }
            if (t instanceof NumberDataType) {
                fm.setDouble(tag, ((Number)value).doubleValue());
                continue;
            }
            if (t instanceof StringDataType) {
                fm.setString(tag, (String)value);
                continue;
            }
            if (t instanceof DateDataType) {
                DateDataType dt = (DateDataType)t;
                if (dt.isDate() && dt.isTime()) {
                    fm.setUtcTimeStamp(tag, (Date)value);
                    continue;
                }
                if (dt.isDate()) {
                    fm.setUtcDateOnly(tag, (Date)value);
                    continue;
                }
                if (dt.isTime()) {
                    fm.setUtcTimeOnly(tag, (Date)value);
                    continue;
                }
                throw new IllegalArgumentException("Unknown date type " + dt.getName());
            }
            throw new IllegalArgumentException("Unknown type " + e.getType().getName());
        }
    }

    private static int tag(DataType t) {
        String[] init = t.getInitiator();
        if (init == null || init.length == 0 || !init[0].endsWith("=")) {
            throw new IllegalArgumentException("Malformed initiator on " + t.getName());
        }
        return Integer.valueOf(init[0].substring(0, init[0].length() - 1));
    }

    private static String sort(String msg) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(msg.split("\\x01")));
        Collections.sort(l);
        StringBuffer sb = new StringBuffer();
        for (String str : l) {
            sb.append(str).append("|");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Reading " + args[0] + "...");
        TextualSource src = new TextualSource((InputStream)new FileInputStream(args[0]));
        ComplexDataObject cdo = src.readObject(NewOrderSingleElement.getInstance());
        System.out.println("Converting...");
        Message msg = FixConverter.convert(cdo);
        System.out.print("ArtixDS :");
        System.out.println(cdo.toString());
        System.out.print("QuickFix:");
        System.out.println(msg.toString());
        System.out.print("ArtixDS :");
        System.out.println(FixConverter.sort(cdo.toString()));
        System.out.print("QuickFix:");
        System.out.println(FixConverter.sort(msg.toString()));
    }
}

