/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.spi.HeaderFilterStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHeaderFilterStrategy
implements HeaderFilterStrategy {
    private Set<String> inFilter;
    private Pattern inFilterPattern;
    private Set<String> outFilter;
    private Pattern outFilterPattern;
    private boolean isLowercase;
    private boolean allowNullValues;

    @Override
    public boolean applyFilterToCamelHeaders(String headerName, Object headerValue) {
        return this.doFiltering(Direction.OUT, headerName, headerValue);
    }

    @Override
    public boolean applyFilterToExternalHeaders(String headerName, Object headerValue) {
        return this.doFiltering(Direction.IN, headerName, headerValue);
    }

    public Set<String> getOutFilter() {
        if (this.outFilter == null) {
            this.outFilter = new HashSet<String>();
        }
        return this.outFilter;
    }

    public void setOutFilter(Set<String> value) {
        this.outFilter = value;
    }

    public String getOutFilterPattern() {
        return this.outFilterPattern == null ? null : this.outFilterPattern.pattern();
    }

    public void setOutFilterPattern(String value) {
        this.outFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public Set<String> getInFilter() {
        if (this.inFilter == null) {
            this.inFilter = new HashSet<String>();
        }
        return this.inFilter;
    }

    public void setInFilter(Set<String> value) {
        this.inFilter = value;
    }

    public String getInFilterPattern() {
        return this.inFilterPattern == null ? null : this.inFilterPattern.pattern();
    }

    public void setInFilterPattern(String value) {
        this.inFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public boolean getIsLowercase() {
        return this.isLowercase;
    }

    public void setIsLowercase(boolean value) {
        this.isLowercase = value;
    }

    public boolean getAllowNullValues() {
        return this.allowNullValues;
    }

    public void setAllowNullValues(boolean value) {
        this.allowNullValues = value;
    }

    protected boolean extendedFilter(Direction direction, String key, Object value) {
        return false;
    }

    private boolean doFiltering(Direction direction, String headerName, Object headerValue) {
        if (headerName == null) {
            return true;
        }
        if (headerValue == null && !this.allowNullValues) {
            return true;
        }
        Pattern pattern = null;
        Set<String> filter = null;
        if (Direction.OUT == direction) {
            pattern = this.outFilterPattern;
            filter = this.outFilter;
        } else if (Direction.IN == direction) {
            pattern = this.inFilterPattern;
            filter = this.inFilter;
        }
        if (pattern != null && pattern.matcher(headerName).matches()) {
            return true;
        }
        if (filter != null && (this.getIsLowercase() ? filter.contains(headerName.toLowerCase()) : filter.contains(headerName))) {
            return true;
        }
        return this.extendedFilter(direction, headerName, headerValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Direction {
        IN,
        OUT;

    }
}

