/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.processor.DelegateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncProcessorTypeConverter
implements TypeConverter {
    @Override
    public <T> T convertTo(Class<T> toType, Object value) {
        if (value != null && toType.equals(AsyncProcessor.class)) {
            if (value instanceof AsyncProcessor) {
                return toType.cast(value);
            }
            if (value instanceof Processor) {
                Processor processor = (Processor)value;
                return toType.cast(new ProcessorToAsyncProcessorBridge(processor));
            }
        }
        return null;
    }

    @Override
    public <T> T convertTo(Class<T> toType, Exchange exchange, Object value) {
        return this.convertTo(toType, value);
    }

    public static AsyncProcessor convert(Processor value) {
        if (value instanceof AsyncProcessor) {
            return (AsyncProcessor)value;
        }
        return new ProcessorToAsyncProcessorBridge(value);
    }

    private static final class ProcessorToAsyncProcessorBridge
    extends DelegateProcessor
    implements AsyncProcessor {
        private ProcessorToAsyncProcessorBridge(Processor processor) {
            super(processor);
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }
}

