/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.language.IllegalSyntaxException;
import org.apache.camel.language.simple.AbstractSimpleLanguage;
import org.apache.camel.language.simple.FileExpressionBuilder;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLanguage
extends AbstractSimpleLanguage {
    public static Expression file(String expression) {
        FileLanguage language = new FileLanguage();
        return language.createExpression(expression);
    }

    protected Expression<FileExchange> createSimpleExpression(String expression) {
        String remainder = this.ifStartsWithReturnRemainder("file:", expression);
        if (remainder != null) {
            if (ObjectHelper.equal(remainder, "name")) {
                return FileExpressionBuilder.fileNameExpression();
            }
            if (ObjectHelper.equal(remainder, "name.noext")) {
                return FileExpressionBuilder.fileNameNoExtensionExpression();
            }
            if (ObjectHelper.equal(remainder, "parent")) {
                return FileExpressionBuilder.fileParentExpression();
            }
            if (ObjectHelper.equal(remainder, "path")) {
                return FileExpressionBuilder.filePathExpression();
            }
            if (ObjectHelper.equal(remainder, "absolute.path")) {
                return FileExpressionBuilder.fileAbsolutePathExpression();
            }
            if (ObjectHelper.equal(remainder, "canonical.path")) {
                return FileExpressionBuilder.fileCanoicalPathExpression();
            }
            if (ObjectHelper.equal(remainder, "length")) {
                return FileExpressionBuilder.fileSizeExpression();
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date:", expression)) != null) {
            String[] parts = remainder.split(":");
            if (parts.length != 2) {
                throw new IllegalSyntaxException(this, expression + " ${date:command:pattern} is the correct syntax.");
            }
            String command = parts[0];
            String pattern = parts[1];
            return FileExpressionBuilder.dateExpression(command, pattern);
        }
        return FileExpressionBuilder.simpleExpression(expression);
    }
}

