/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.model.OptionalIdentifiedType;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="from")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FromType
extends OptionalIdentifiedType<FromType> {
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String ref;
    @XmlTransient
    private Endpoint<? extends Exchange> endpoint;

    public FromType() {
    }

    public FromType(String uri) {
        this.setUri(uri);
    }

    public FromType(Endpoint<? extends Exchange> endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "From[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "from";
    }

    public String getLabel() {
        return FromType.description(this.getUri(), this.getRef(), this.getEndpoint());
    }

    public Endpoint<? extends Exchange> resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            this.endpoint = context.resolveEndpoint(this.getUri(), this.getRef());
        }
        return this.endpoint;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Object getUriOrRef() {
        if (ObjectHelper.isNullOrBlank(this.uri)) {
            return this.uri;
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return this.ref;
    }

    protected static String description(String uri, String ref, Endpoint endpoint) {
        if (ref != null) {
            return "ref:" + ref;
        }
        if (endpoint != null) {
            return endpoint.getEndpointUri();
        }
        if (uri != null) {
            return uri;
        }
        return "no uri or ref supplied!";
    }
}

