/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
SynchronousBundleListener {
    public static final String META_INF_TYPE_CONVERTER = "META-INF/services/org/apache/camel/TypeConverter";
    public static final String META_INF_COMPONENT = "META-INF/services/org/apache/camel/component/";
    public static final String META_INF_LANGUAGE = "META-INF/services/org/apache/camel/language/";
    private static final transient Log LOG = LogFactory.getLog(Activator.class);
    private static final Map<String, ComponentEntry> COMPONENTS = new HashMap<String, ComponentEntry>();
    private static final Map<URL, TypeConverterEntry> TYPE_CONVERTERS = new HashMap<URL, TypeConverterEntry>();
    private static final Map<String, ComponentEntry> LANGUAGES = new HashMap<String, ComponentEntry>();
    private static Bundle bundle;

    public void bundleChanged(BundleEvent event) {
        try {
            Bundle bundle = event.getBundle();
            if (event.getType() == 32) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Bundle resolved: " + bundle.getSymbolicName()));
                }
                this.mayBeAddComponentAndLanguageFor(bundle);
                this.mayBeAddTypeConverterFor(bundle);
            } else if (event.getType() == 64) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Bundle unresolved: " + bundle.getSymbolicName()));
                }
                this.mayBeRemoveComponentAndLanguageFor(bundle);
                this.mayBeRemoveTypeConverterFor(bundle);
            }
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Exception handing bundle changed event", e);
        }
    }

    protected synchronized void addComponentEntry(String entryPath, Bundle bundle, Map<String, ComponentEntry> entries) {
        Enumeration e = bundle.getEntryPaths(entryPath);
        if (e != null) {
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found entry: " + path + " in bundle " + bundle.getSymbolicName()));
                }
                ComponentEntry entry = new ComponentEntry();
                entry.bundle = bundle;
                entry.path = path;
                entry.name = path.substring(path.lastIndexOf("/") + 1);
                entries.put(entry.name, entry);
            }
        }
    }

    protected void mayBeAddComponentAndLanguageFor(Bundle bundle) {
        this.addComponentEntry(META_INF_COMPONENT, bundle, COMPONENTS);
        this.addComponentEntry(META_INF_LANGUAGE, bundle, LANGUAGES);
    }

    protected synchronized void mayBeAddTypeConverterFor(Bundle bundle) {
        try {
            Enumeration e = bundle.getResources(META_INF_TYPE_CONVERTER);
            if (e != null) {
                while (e.hasMoreElements()) {
                    URL resource = (URL)e.nextElement();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found entry: " + resource + " in bundle " + bundle.getSymbolicName()));
                    }
                    TypeConverterEntry entry = new TypeConverterEntry();
                    entry.bundle = bundle;
                    entry.resource = resource;
                    entry.converterPackages = this.getConverterPackages(resource);
                    TYPE_CONVERTERS.put(resource, entry);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void mayBeRemoveComponentAndLanguageFor(Bundle bundle) {
        this.removeComponentEntry(bundle, COMPONENTS);
        this.removeComponentEntry(bundle, LANGUAGES);
    }

    protected void removeComponentEntry(Bundle bundle, Map<String, ComponentEntry> entries) {
        ComponentEntry[] entriesArray;
        for (ComponentEntry entry : entriesArray = entries.values().toArray(new ComponentEntry[0])) {
            if (entry.bundle != bundle) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing entry: " + entry.path + " in bundle " + bundle.getSymbolicName()));
            }
            entries.remove(entry.name);
        }
    }

    protected synchronized void mayBeRemoveTypeConverterFor(Bundle bundle) {
        TypeConverterEntry[] entriesArray;
        for (TypeConverterEntry entry : entriesArray = TYPE_CONVERTERS.values().toArray(new TypeConverterEntry[0])) {
            if (entry.bundle != bundle) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing entry: " + entry.resource + " in bundle " + bundle.getSymbolicName()));
            }
            COMPONENTS.remove(entry.resource);
        }
    }

    public void start(BundleContext context) throws Exception {
        bundle = context.getBundle();
        context.addBundleListener((BundleListener)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"checking existing bundles");
        }
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.mayBeAddComponentAndLanguageFor(bundle);
            this.mayBeAddTypeConverterFor(bundle);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"actived");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removing the components of existing bundles");
        }
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.mayBeRemoveComponentAndLanguageFor(bundle);
            this.mayBeRemoveTypeConverterFor(bundle);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<String> getConverterPackages(URL resource) {
        HashSet<String> packages = new HashSet<String>();
        if (resource == null) return packages;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                this.tokenize(packages, line);
            }
            if (reader == null) return packages;
        }
        catch (Exception ignore) {
            if (reader == null) return packages;
            ObjectHelper.close(reader, null, LOG);
            return packages;
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                ObjectHelper.close(reader, null, LOG);
                throw throwable;
            }
        }
        ObjectHelper.close(reader, null, LOG);
        return packages;
    }

    protected void tokenize(Set<String> packages, String line) {
        StringTokenizer iter = new StringTokenizer(line, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() <= 0) continue;
            packages.add(name);
        }
    }

    protected static Bundle getBundle() {
        return bundle;
    }

    protected static synchronized String[] findTypeConverterPackageNames() {
        HashSet<String> packages = new HashSet<String>();
        for (TypeConverterEntry entry : TYPE_CONVERTERS.values()) {
            for (String packageName : entry.converterPackages) {
                packages.add(packageName);
            }
        }
        return packages.toArray(new String[packages.size()]);
    }

    public static synchronized Class getComponent(String name) throws Exception {
        return Activator.getClassFromEntries(name, COMPONENTS);
    }

    public static synchronized Class getLanguage(String name) throws Exception {
        return Activator.getClassFromEntries(name, LANGUAGES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized Class getClassFromEntries(String name, Map<String, ComponentEntry> entries) throws Exception {
        ComponentEntry entry = entries.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.type == null) {
            URL url = entry.bundle.getEntry(entry.path);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The entry " + name + "'s url is" + url));
            }
            Properties properties = new Properties();
            BufferedInputStream reader = null;
            try {
                reader = new BufferedInputStream(url.openStream());
                properties.load(reader);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception ignore) {}
            }
            String classname = (String)properties.get("class");
            BundleDelegatingClassLoader loader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)entry.bundle);
            entry.type = loader.loadClass(classname);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found entry: " + name + " via type: " + entry.type.getName()));
        }
        return entry.type;
    }

    private class TypeConverterEntry {
        Bundle bundle;
        URL resource;
        Set<String> converterPackages;

        private TypeConverterEntry() {
        }
    }

    private class ComponentEntry {
        Bundle bundle;
        String path;
        String name;
        Class type;

        private ComponentEntry() {
        }
    }
}

