/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.osgi.OsgiAnnotationTypeConverterLoader;
import org.apache.camel.osgi.OsgiComponentResolver;
import org.apache.camel.osgi.OsgiFactoryFinder;
import org.apache.camel.osgi.OsgiLanguageResolver;
import org.apache.camel.osgi.OsgiResolverUtil;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ResolverUtil;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends org.apache.camel.spring.CamelContextFactoryBean
implements BundleContextAware {
    @XmlTransient
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext context = super.createContext();
        if (this.bundleContext != null) {
            context.setComponentResolver(new OsgiComponentResolver());
            context.setLanguageResolver(new OsgiLanguageResolver());
            this.addOsgiAnnotationTypeConverterLoader(context, this.bundleContext);
            context.setFactoryFinderClass(OsgiFactoryFinder.class);
        }
        return context;
    }

    protected ResolverUtil createResolverUtil() {
        if (this.bundleContext != null) {
            return new OsgiResolverUtil(this.bundleContext);
        }
        return new ResolverUtil();
    }

    protected void addOsgiAnnotationTypeConverterLoader(SpringCamelContext context, BundleContext bundleContext) {
        DefaultTypeConverter typeConverter = (DefaultTypeConverter)context.getTypeConverter();
        List<TypeConverterLoader> typeConverterLoaders = typeConverter.getTypeConverterLoaders();
        TypeConverterLoader atLoader = null;
        for (TypeConverterLoader loader : typeConverterLoaders) {
            if (!(loader instanceof AnnotationTypeConverterLoader)) continue;
            atLoader = loader;
            break;
        }
        if (atLoader != null) {
            typeConverterLoaders.remove(atLoader);
        }
        typeConverterLoaders.add(new OsgiAnnotationTypeConverterLoader(bundleContext));
    }
}

