/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.AsyncProcessorHelper;

public class HandleFaultProcessor
extends DelegateProcessor
implements AsyncProcessor {
    public String toString() {
        return "HandleFaultProcessor(" + this.processor + ")";
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Object faultBody;
        if (this.processor == null) {
            callback.done(true);
            return true;
        }
        if (this.processor instanceof AsyncProcessor) {
            return ((AsyncProcessor)this.processor).process(exchange, new AsyncCallback(){

                public void done(boolean doneSynchronously) {
                    Object faultBody;
                    Message faultMessage = exchange.getFault(false);
                    if (faultMessage != null && (faultBody = faultMessage.getBody()) != null) {
                        faultMessage.setBody(null);
                        if (faultBody instanceof Throwable) {
                            exchange.setException((Throwable)faultBody);
                        } else if (exchange.getException() == null) {
                            exchange.setException(new CamelException("Message contains fault of type " + faultBody.getClass().getName() + ":\n" + faultBody));
                        }
                    }
                    callback.done(doneSynchronously);
                }
            });
        }
        try {
            this.processor.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        Message faultMessage = exchange.getFault(false);
        if (faultMessage != null && (faultBody = faultMessage.getBody()) != null) {
            faultMessage.setBody(null);
            if (faultBody instanceof Throwable) {
                exchange.setException((Throwable)faultBody);
            } else if (exchange.getException() == null) {
                exchange.setException(new CamelException("Message contains fault of type " + faultBody.getClass().getName() + ":\n" + faultBody));
            }
        }
        callback.done(true);
        return true;
    }
}

