/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.interceptor.Delayer;

public class DelayInterceptor
extends DelayProcessorSupport {
    private final ProcessorType node;
    private Delayer delayer;

    public DelayInterceptor(ProcessorType node, Processor target, Delayer delayer) {
        super(target);
        this.node = node;
        this.delayer = delayer;
    }

    public String toString() {
        return "DelayInterceptor[delay: " + this.delayer.getDelay() + " on: " + this.node + "]";
    }

    public void delay(Exchange exchange) throws Exception {
        if (this.delayer.isEnabled()) {
            long time = this.currentSystemTime() + this.delayer.getDelay();
            this.waitUntil(time, exchange);
        }
    }
}

