/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.Endpoint;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.spi.ApplicationContextRegistry;
import org.apache.camel.spring.spi.SpringInjector;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContext
extends DefaultCamelContext
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final transient Log LOG = LogFactory.getLog(SpringCamelContext.class);
    private ApplicationContext applicationContext;
    private EventEndpoint eventEndpoint;
    private boolean shouldStartContext = ObjectHelper.getSystemProperty("shouldStartContext", Boolean.TRUE);

    public SpringCamelContext() {
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext) throws Exception {
        String[] names = applicationContext.getBeanNamesForType(SpringCamelContext.class);
        if (names.length == 1) {
            return (SpringCamelContext)applicationContext.getBean(names[0], SpringCamelContext.class);
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        answer.afterPropertiesSet();
        return answer;
    }

    public static SpringCamelContext springCamelContext(String configLocations) throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)new ClassPathXmlApplicationContext(configLocations));
    }

    public void afterPropertiesSet() throws Exception {
        this.maybeStart();
    }

    private void maybeStart() throws Exception {
        if (this.getShouldStartContext()) {
            LOG.debug((Object)"Starting the CamelContext now that the ApplicationContext has started");
            this.start();
        } else {
            LOG.debug((Object)"Not starting the CamelContext since shouldStartContext property was false.");
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Publishing spring-event: " + event));
        }
        if (event instanceof ContextRefreshedEvent) {
            try {
                this.maybeStart();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            if (this.eventEndpoint != null) {
                this.eventEndpoint.onApplicationEvent(event);
            }
        } else if (this.eventEndpoint != null) {
            this.eventEndpoint.onApplicationEvent(event);
        } else {
            LOG.warn((Object)("No spring-event endpoint enabled for: " + event));
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.addComponent("spring-event", new EventComponent(applicationContext));
        }
    }

    public EventEndpoint getEventEndpoint() {
        return this.eventEndpoint;
    }

    public void setEventEndpoint(EventEndpoint eventEndpoint) {
        this.eventEndpoint = eventEndpoint;
    }

    protected void doStart() throws Exception {
        this.maybeDoStart();
    }

    protected void maybeDoStart() throws Exception {
        if (this.getShouldStartContext()) {
            super.doStart();
            if (this.eventEndpoint == null) {
                this.eventEndpoint = this.createEventEndpoint();
            }
        }
    }

    protected Injector createInjector() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            return new SpringInjector((ConfigurableApplicationContext)this.applicationContext);
        }
        LOG.warn((Object)("Cannot use SpringInjector as applicationContext is not a ConfigurableApplicationContext as its: " + this.applicationContext));
        return super.createInjector();
    }

    protected EventEndpoint createEventEndpoint() {
        EventEndpoint endpoint = this.getEndpoint("spring-event:default", EventEndpoint.class);
        return endpoint;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        try {
            Endpoint endpoint = this.getTypeConverter().convertTo(Endpoint.class, bean);
            if (endpoint != null) {
                endpoint.setCamelContext(this);
                return endpoint;
            }
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
        return new ProcessorEndpoint(uri, this, (Processor)new BeanProcessor(bean, this));
    }

    protected Registry createRegistry() {
        return new ApplicationContextRegistry(this.getApplicationContext());
    }

    public void setShouldStartContext(boolean shouldStartContext) {
        this.shouldStartContext = shouldStartContext;
    }

    public boolean getShouldStartContext() {
        return this.shouldStartContext;
    }
}

