/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import java.io.Serializable;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.processor.cache.CacheValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedMessageBodyReplacer
extends CacheValidate
implements Processor {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheBasedMessageBodyReplacer.class);
    CacheManager cacheManager;
    Ehcache cache;
    private String cacheName;
    private String key;

    public CacheBasedMessageBodyReplacer(String cacheName, String key) {
        if (cacheName.contains("cache://")) {
            this.setCacheName(cacheName.replace("cache://", ""));
        } else {
            this.setCacheName(cacheName);
        }
        this.setKey(key);
    }

    public void process(Exchange exchange) throws Exception {
        this.cacheManager = new DefaultCacheManagerFactory().getInstance();
        if (this.isValid(this.cacheManager, this.cacheName, this.key)) {
            this.cache = this.cacheManager.getCache(this.cacheName);
            LOG.debug("Replacing Message Body from CacheName {} for key {}", (Object)this.cacheName, (Object)this.key);
            exchange.getIn().setHeader("CamelCacheKey", (Object)this.key);
            exchange.getIn().setBody(this.cache.get((Serializable)((Object)this.key)).getObjectValue());
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

