/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.factory.CacheManagerFactory;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(CacheProducer.class);
    Endpoint endpoint;
    CacheConfiguration config;
    CacheManager cacheManager;
    Ehcache cache;

    public CacheProducer(Endpoint endpoint, CacheConfiguration config) throws Exception {
        super(endpoint);
        this.endpoint = endpoint;
        this.config = config;
    }

    public void process(Exchange exchange) throws Exception {
        this.cacheManager = new CacheManagerFactory().instantiateCacheManager();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cache Name: " + this.config.getCacheName()));
        }
        if (this.cacheManager.cacheExists(this.config.getCacheName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found an existing cache: " + this.config.getCacheName()));
                LOG.trace((Object)("Cache " + this.config.getCacheName() + " currently contains " + this.cacheManager.getCache(this.config.getCacheName()).getSize() + " elements"));
            }
            this.cache = this.cacheManager.getCache(this.config.getCacheName());
        } else {
            this.cache = new Cache(this.config.getCacheName(), this.config.getMaxElementsInMemory(), this.config.getMemoryStoreEvictionPolicy(), this.config.isOverflowToDisk(), this.config.getDiskStorePath(), this.config.isEternal(), this.config.getTimeToLiveSeconds(), this.config.getTimeToIdleSeconds(), this.config.isDiskPersistent(), this.config.getDiskExpiryThreadIntervalSeconds(), null);
            this.cacheManager.addCache(this.cache);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added a new cache: " + this.cache.getName()));
            }
        }
        String key = (String)exchange.getIn().getHeader("CACHE_KEY");
        String operation = (String)exchange.getIn().getHeader("CACHE_OPERATION");
        if (operation == null) {
            throw new CacheException("Operation property is not specified in the incoming exchange header.A valid Operation property must be set to ADD, UPDATE, DELETE, DELETEALL");
        }
        if (key == null && !operation.equalsIgnoreCase("DELETEALL")) {
            throw new CacheException("Cache Key is not specified in exchange either header or URL. Unable to add objects to the cache without a Key");
        }
        this.performCacheOperation(exchange, operation, key);
    }

    private void performCacheOperation(Exchange exchange, String operation, String key) throws Exception {
        Object element;
        Object body = exchange.getIn().getBody();
        if (body instanceof Serializable) {
            element = body;
        } else {
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
            byte[] buffer = new byte[is.available()];
            int n = is.available();
            for (int j = 0; j < n; ++j) {
                buffer[j] = (byte)is.read();
            }
            element = buffer;
        }
        if (operation.equalsIgnoreCase("ADD")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding an element with key " + key + " into the Cache"));
            }
            this.cache.put(new Element((Object)key, element), true);
        } else if (operation.equalsIgnoreCase("UPDATE")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating an element with key " + key + " into the Cache"));
            }
            this.cache.put(new Element((Object)key, element), true);
        } else if (operation.equalsIgnoreCase("DELETEALL")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Deleting All elements from the Cache");
            }
            this.cache.removeAll();
        } else if (operation.equalsIgnoreCase("DELETE")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting an element with key " + key + " into the Cache"));
            }
            this.cache.remove((Serializable)((Object)key), true);
        }
    }
}

