/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheConsumer;
import org.apache.camel.component.cache.CacheProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(CacheEndpoint.class);
    CacheConfiguration config;

    public CacheEndpoint(String endpointUri, Component component, CacheConfiguration config) {
        super(endpointUri, component);
        this.config = config;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CacheConsumer((Endpoint)this, processor, this.config);
    }

    public Producer createProducer() throws Exception {
        return new CacheProducer((Endpoint)this, this.config);
    }

    public boolean isSingleton() {
        return false;
    }

    public CacheConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CacheConfiguration config) {
        this.config = config;
    }

    public Exchange createCacheExchange(String operation, String key, Object value) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        message.setHeader("CACHE_OPERATION", (Object)operation);
        message.setHeader("CACHE_KEY", (Object)key);
        message.setBody(value);
        exchange.setIn((Message)message);
        return exchange;
    }
}

