/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheValidate {
    private static final transient Log LOG = LogFactory.getLog(CacheValidate.class);

    public boolean isValid(CacheManager cacheManager, String cacheName, String key) {
        Cache cache;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cache Name: " + cacheName));
        }
        if (!cacheManager.cacheExists(cacheName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No existing Cache found with name: " + cacheName + ". Please ensure a cache is first instantiated using a Cache Consumer or Cache Producer." + " Replacement will not be performed since the cache " + cacheName + "does not presently exist"));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found an existing cache: " + cacheName));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cache " + cacheName + " currently contains " + cacheManager.getCache(cacheName).getSize() + " elements"));
        }
        if (!(cache = cacheManager.getCache(cacheName)).isKeyInCache((Object)key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No Key with name: " + key + "presently exists in the cache. It is also possible that the key may have expired in the cache." + " Replacement will not be performed until an appropriate key/value pair is added to (or) found in the cache."));
            }
            return false;
        }
        return true;
    }
}

