/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class CacheComponent
extends DefaultComponent {
    private CacheConfiguration configuration;
    private CacheManagerFactory cacheManagerFactory = new CacheManagerFactory();

    public CacheComponent() {
        this.configuration = new CacheConfiguration();
    }

    public CacheComponent(CamelContext context) {
        super(context);
        this.configuration = new CacheConfiguration();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        CacheConfiguration config = this.configuration.copy();
        config.parseURI(new URI(uri));
        CacheEndpoint cacheEndpoint = new CacheEndpoint(uri, (Component)this, config, this.cacheManagerFactory);
        this.setProperties(cacheEndpoint.getConfig(), parameters);
        return cacheEndpoint;
    }

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public CacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CacheConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)((Object)this.cacheManagerFactory));
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.cacheManagerFactory));
        super.doStop();
    }
}

