/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheConsumer;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.component.cache.CacheProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class CacheEndpoint
extends DefaultEndpoint {
    private CacheConfiguration config;
    private CacheManagerFactory cacheManagerFactory;

    public CacheEndpoint() {
    }

    public CacheEndpoint(String endpointUri, Component component, CacheConfiguration config, CacheManagerFactory cacheManagerFactory) {
        super(endpointUri, component);
        this.config = config;
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.config, (String)"config");
        ObjectHelper.notNull((Object)((Object)this.cacheManagerFactory), (String)"cacheManagerFactory");
        return new CacheConsumer((Endpoint)this, processor, this.config);
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.config, (String)"config");
        ObjectHelper.notNull((Object)((Object)this.cacheManagerFactory), (String)"cacheManagerFactory");
        return new CacheProducer((Endpoint)this, this.config);
    }

    public boolean isSingleton() {
        return true;
    }

    public CacheConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CacheConfiguration config) {
        this.config = config;
    }

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public Exchange createCacheExchange(String operation, String key, Object value) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        message.setHeader("CACHE_OPERATION", (Object)operation);
        message.setHeader("CACHE_KEY", (Object)key);
        message.setBody(value);
        exchange.setIn((Message)message);
        return exchange;
    }
}

