/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.processor.cache.CacheValidate;
import org.apache.camel.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class CacheBasedXPathReplacer
extends CacheValidate
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(CacheBasedXPathReplacer.class);
    private String cacheName;
    private String key;
    private String xpath;
    private CacheManager cacheManager;
    private Ehcache cache;
    private Document document;
    private DOMSource source;
    private DOMResult result;

    public CacheBasedXPathReplacer(String cacheName, String key, String xpath) {
        if (cacheName.contains("cache://")) {
            this.setCacheName(cacheName.replace("cache://", ""));
        } else {
            this.setCacheName(cacheName);
        }
        this.key = key;
        this.xpath = xpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        this.cacheManager = new DefaultCacheManagerFactory().instantiateCacheManager();
        if (this.isValid(this.cacheManager, this.cacheName, this.key)) {
            this.cache = this.cacheManager.getCache(this.cacheName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Replacing XPath value " + this.xpath + "in Message with value stored against key " + this.key + " in CacheName " + this.cacheName));
            }
            exchange.getIn().setHeader("CACHE_KEY", (Object)this.key);
            Object body = exchange.getIn().getBody();
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, body);
            try {
                this.document = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"is", (Log)LOG);
            }
            InputStream cis = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, this.cache.get((Serializable)((Object)this.key)).getObjectValue());
            try {
                Document cacheValueDocument = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)cis);
                XmlConverter xmlConverter = new XmlConverter();
                String xslString = IOConverter.toString((File)new File("./src/main/resources/xpathreplacer.xsl"), (Exchange)exchange);
                xslString = xslString.replace("##match_token##", this.xpath);
                StreamSource xslSource = xmlConverter.toStreamSource((Reader)new StringReader(xslString));
                TransformerFactory transformerFactory = xmlConverter.createTransformerFactory();
                Transformer transformer = transformerFactory.newTransformer(xslSource);
                this.source = xmlConverter.toDOMSource(this.document);
                this.result = new DOMResult();
                transformer.setParameter("cacheValue", cacheValueDocument);
                transformer.transform(this.source, this.result);
            }
            finally {
                IOHelper.close((Closeable)cis, (String)"cis", (Log)LOG);
            }
        }
        DOMSource dom = new DOMSource(this.result.getNode());
        exchange.getIn().setBody((Object)dom, byte[].class);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }
}

