/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.component.cache.CacheEventListener;
import org.apache.camel.component.cache.CacheEventListenerFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheConsumer.class);
    private CacheConfiguration config;
    private Ehcache cache;
    private CacheManager cacheManager;

    public CacheConsumer(Endpoint endpoint, Processor processor, CacheConfiguration config) {
        super(endpoint, processor);
        this.config = config;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createConsumerCacheConnection();
    }

    protected void doStop() throws Exception {
        this.removeConsumerCacheConnection();
        super.doStop();
    }

    public CacheEndpoint getEndpoint() {
        return (CacheEndpoint)super.getEndpoint();
    }

    protected void createConsumerCacheConnection() {
        this.cacheManager = this.getEndpoint().getCacheManagerFactory().instantiateCacheManager();
        CacheEventListener cacheEventListener = new CacheEventListenerFactory().createCacheEventListener(null);
        cacheEventListener.setCacheConsumer(this);
        if (this.cacheManager.cacheExists(this.config.getCacheName())) {
            this.cache = this.cacheManager.getCache(this.config.getCacheName());
            this.cache.getCacheEventNotificationService().registerListener((net.sf.ehcache.event.CacheEventListener)cacheEventListener);
        } else {
            this.cache = new Cache(this.config.getCacheName(), this.config.getMaxElementsInMemory(), this.config.getMemoryStoreEvictionPolicy(), this.config.isOverflowToDisk(), this.config.getDiskStorePath(), this.config.isEternal(), this.config.getTimeToLiveSeconds(), this.config.getTimeToIdleSeconds(), this.config.isDiskPersistent(), this.config.getDiskExpiryThreadIntervalSeconds(), null);
            this.cache.getCacheEventNotificationService().registerListener((net.sf.ehcache.event.CacheEventListener)cacheEventListener);
            this.cacheManager.addCache(this.cache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added a new cache: " + this.cache.getName());
            }
        }
    }

    protected void removeConsumerCacheConnection() {
        this.cacheManager.removeCache(this.config.getCacheName());
    }
}

