/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheProducer.class);
    private CacheConfiguration config;
    private CacheManager cacheManager;
    private Ehcache cache;

    public CacheProducer(Endpoint endpoint, CacheConfiguration config) throws Exception {
        super(endpoint);
        this.config = config;
    }

    protected void doStart() throws Exception {
        this.cacheManager = this.getEndpoint().getCacheManagerFactory().instantiateCacheManager();
        super.doStart();
    }

    public CacheEndpoint getEndpoint() {
        return (CacheEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache Name: " + this.config.getCacheName());
        }
        if (this.cacheManager.cacheExists(this.config.getCacheName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found an existing cache: " + this.config.getCacheName());
                LOG.trace("Cache " + this.config.getCacheName() + " currently contains " + this.cacheManager.getCache(this.config.getCacheName()).getSize() + " elements");
            }
            this.cache = this.cacheManager.getCache(this.config.getCacheName());
        } else {
            this.cache = new Cache(this.config.getCacheName(), this.config.getMaxElementsInMemory(), this.config.getMemoryStoreEvictionPolicy(), this.config.isOverflowToDisk(), this.config.getDiskStorePath(), this.config.isEternal(), this.config.getTimeToLiveSeconds(), this.config.getTimeToIdleSeconds(), this.config.isDiskPersistent(), this.config.getDiskExpiryThreadIntervalSeconds(), null);
            this.cacheManager.addCache(this.cache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added a new cache: " + this.cache.getName());
            }
        }
        String key = (String)exchange.getIn().getHeader("CACHE_KEY", String.class);
        String operation = (String)exchange.getIn().getHeader("CACHE_OPERATION", String.class);
        if (operation == null) {
            throw new CacheException("Operation not specified in the message header [CACHE_KEY]");
        }
        if (key == null && !operation.equalsIgnoreCase("DELETEALL")) {
            throw new CacheException("Cache Key is not specified in message header header or endpoint URL.");
        }
        this.performCacheOperation(exchange, operation, key);
    }

    private void performCacheOperation(Exchange exchange, String operation, String key) throws Exception {
        if (operation.equalsIgnoreCase("ADD")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding an element with key " + key + " into the Cache");
            }
            Object element = this.createElementFromBody(exchange, "ADD");
            this.cache.put(new Element((Object)key, element), true);
        } else if (operation.equalsIgnoreCase("UPDATE")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating an element with key " + key + " into the Cache");
            }
            Object element = this.createElementFromBody(exchange, "UPDATE");
            this.cache.put(new Element((Object)key, element), true);
        } else if (operation.equalsIgnoreCase("DELETEALL")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting All elements from the Cache");
            }
            this.cache.removeAll();
        } else if (operation.equalsIgnoreCase("DELETE")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting an element with key " + key + " into the Cache");
            }
            this.cache.remove((Serializable)((Object)key), true);
        } else if (operation.equalsIgnoreCase("GET")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Quering an element with key " + key + " from the Cache");
            }
            if (this.cache.isKeyInCache((Object)key) && this.cache.get((Serializable)((Object)key)) != null) {
                exchange.getIn().setHeader("CACHE_ELEMENT_WAS_FOUND", (Object)true);
                exchange.getIn().setBody((Object)this.cache.get((Serializable)((Object)key)).getValue());
            } else {
                exchange.getIn().removeHeader("CACHE_ELEMENT_WAS_FOUND");
            }
        } else if (operation.equalsIgnoreCase("CHECK")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Querying an element with key " + key + " from the Cache");
            }
            if (this.cache.isKeyInCache((Object)key)) {
                exchange.getIn().setHeader("CACHE_ELEMENT_WAS_FOUND", (Object)true);
            } else {
                exchange.getIn().removeHeader("CACHE_ELEMENT_WAS_FOUND");
            }
        } else {
            throw new CacheException("Operation " + operation + " is not supported.");
        }
    }

    private Object createElementFromBody(Exchange exchange, String cacheOperation) throws NoTypeConversionAvailableException {
        Object element;
        Object body = exchange.getIn().getBody();
        if (body == null) {
            throw new CacheException("Body cannot be null for operation " + cacheOperation);
        }
        if (body instanceof Serializable) {
            element = body;
        } else {
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
            element = exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, (Object)is);
        }
        return element;
    }
}

