/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.processor.cache.CacheValidate;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedTokenReplacer
extends CacheValidate
implements Processor {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheBasedTokenReplacer.class);
    private String cacheName;
    private String key;
    private String replacementToken;
    private CacheManager cacheManager;
    private Ehcache cache;

    public CacheBasedTokenReplacer(String cacheName, String key, String replacementToken) {
        if (cacheName.contains("cache://")) {
            this.setCacheName(cacheName.replace("cache://", ""));
        } else {
            this.setCacheName(cacheName);
        }
        this.setKey(key);
        this.setReplacementToken(replacementToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        this.cacheManager = new DefaultCacheManagerFactory().instantiateCacheManager();
        if (this.isValid(this.cacheManager, this.cacheName, this.key)) {
            byte[] buffer;
            this.cache = this.cacheManager.getCache(this.cacheName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Replacing Token " + this.replacementToken + "in Message with value stored against key " + this.key + " in CacheName " + this.cacheName);
            }
            exchange.getIn().setHeader("CACHE_KEY", (Object)this.key);
            Object body = exchange.getIn().getBody();
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, body);
            try {
                buffer = IOConverter.toBytes((InputStream)is);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"is", (Logger)LOG);
            }
            String cacheValue = (String)exchange.getContext().getTypeConverter().convertTo(String.class, this.cache.get((Serializable)((Object)this.key)).getObjectValue());
            String replacedTokenString = new String(buffer).replaceAll(this.replacementToken, cacheValue);
            if (LOG.isTraceEnabled()) {
                LOG.trace("replacedTokenString = " + replacedTokenString);
            }
            exchange.getIn().setBody((Object)replacedTokenString.getBytes());
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getReplacementToken() {
        return this.replacementToken;
    }

    public void setReplacementToken(String replacementToken) {
        this.replacementToken = replacementToken;
    }
}

