/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheValidate {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheValidate.class);

    public boolean isValid(CacheManager cacheManager, String cacheName, String key) {
        Cache cache;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache Name: " + cacheName);
        }
        if (!cacheManager.cacheExists(cacheName)) {
            LOG.debug("No existing Cache found with name: {}. Please ensure a cache is first instantiated using a Cache Consumer or Cache Producer. Replacement will not be performed since the cache {} does not presently exist", (Object)cacheName, (Object)cacheName);
            return false;
        }
        LOG.debug("Found an existing cache: {}", (Object)cacheName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache " + cacheName + " currently contains " + cacheManager.getCache(cacheName).getSize() + " elements");
        }
        if (!(cache = cacheManager.getCache(cacheName)).isKeyInCache((Object)key)) {
            LOG.debug("No Key with name: {} presently exists in the cache. It is also possible that the key may have expired in the cache. Replacement will not be performed until an appropriate key/value pair is added to (or) found in the cache.", (Object)key);
            return false;
        }
        return true;
    }
}

