/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.camel.Exchange;
import org.apache.camel.component.cache.CacheConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEventListener
implements net.sf.ehcache.event.CacheEventListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheEventListener.class);
    CacheConsumer cacheConsumer;

    public CacheEventListener() {
    }

    public CacheEventListener(CacheConsumer cacheConsumer) {
        this.cacheConsumer = cacheConsumer;
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Element" + element.toString() + " is being evicted from cache " + cache.getName());
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Element" + element.toString() + " has expired in cache " + cache.getName());
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Element" + element.toString() + " has just been added/put in cache " + cache.getName());
        }
        this.dispatchExchange(cache, element, "ADD");
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Element" + element.toString() + " has just been removed from cache " + cache.getName());
        }
        this.dispatchExchange(cache, element, "DELETE");
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Element" + element.toString() + " has just been updated in cache " + cache.getName());
        }
        this.dispatchExchange(cache, element, "UPDATE");
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache " + cache.getName() + " is being emptied and all elements removed");
        }
        this.dispatchExchange(cache, null, "DELETEALL");
    }

    private void dispatchExchange(Ehcache cache, Element element, String operation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Consumer Dispatching the Exchange containing the Element " + element.toString() + " in cache " + cache.getName());
        }
        Exchange exchange = element == null ? this.cacheConsumer.getEndpoint().createCacheExchange(operation, "", "") : this.cacheConsumer.getEndpoint().createCacheExchange(operation, (String)element.getObjectKey(), element.getObjectValue());
        try {
            this.cacheConsumer.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new CacheException("Error in consumer while dispatching exchange containing key " + (element != null ? element.getObjectKey() : null) + " for further processing", (Throwable)e);
        }
    }

    public CacheConsumer getCacheConsumer() {
        return this.cacheConsumer;
    }

    public void setCacheConsumer(CacheConsumer cacheConsumer) {
        this.cacheConsumer = cacheConsumer;
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

