/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.loader.CacheLoader;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheConsumer;
import org.apache.camel.component.cache.CacheLoaderWrapper;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.component.cache.CacheProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheEndpoint.class);
    private CacheConfiguration config;
    private CacheManagerFactory cacheManagerFactory;

    public CacheEndpoint() {
    }

    public CacheEndpoint(String endpointUri, Component component, CacheConfiguration config, CacheManagerFactory cacheManagerFactory) {
        super(endpointUri, component);
        this.config = config;
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.config, (String)"config");
        ObjectHelper.notNull((Object)((Object)this.cacheManagerFactory), (String)"cacheManagerFactory");
        return new CacheConsumer((Endpoint)this, processor, this.config);
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.config, (String)"config");
        ObjectHelper.notNull((Object)((Object)this.cacheManagerFactory), (String)"cacheManagerFactory");
        return new CacheProducer((Endpoint)this, this.config);
    }

    public boolean isSingleton() {
        return true;
    }

    public CacheConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CacheConfiguration config) {
        this.config = config;
    }

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public Exchange createCacheExchange(String operation, String key, Object value) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        message.setHeader("CamelCacheOperation", (Object)operation);
        message.setHeader("CamelCacheKey", (Object)key);
        message.setBody(value);
        exchange.setIn((Message)message);
        return exchange;
    }

    public Ehcache initializeCache() {
        Cache cache;
        CacheManager cacheManager = this.getCacheManagerFactory().getInstance();
        if (cacheManager.cacheExists(this.config.getCacheName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found an existing cache: {}", (Object)this.config.getCacheName());
                LOG.trace("Cache {} currently contains {} elements", (Object)this.config.getCacheName(), (Object)cacheManager.getCache(this.config.getCacheName()).getSize());
            }
            cache = cacheManager.getCache(this.config.getCacheName());
        } else {
            cache = new Cache(this.config.getCacheName(), this.config.getMaxElementsInMemory(), this.config.getMemoryStoreEvictionPolicy(), this.config.isOverflowToDisk(), this.config.getDiskStorePath(), this.config.isEternal(), this.config.getTimeToLiveSeconds(), this.config.getTimeToIdleSeconds(), this.config.isDiskPersistent(), this.config.getDiskExpiryThreadIntervalSeconds(), null);
            for (CacheEventListener listener : this.config.getEventListenerRegistry().getEventListeners()) {
                cache.getCacheEventNotificationService().registerListener(listener);
            }
            for (CacheLoaderWrapper loader : this.config.getCacheLoaderRegistry().getCacheLoaders()) {
                loader.init((Ehcache)cache);
                cache.registerCacheLoader((CacheLoader)loader);
            }
            cacheManager.addCache(cache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added a new cache: " + cache.getName());
            }
        }
        return cache;
    }

    public void stop() {
        CacheManager cacheManager = this.getCacheManagerFactory().getInstance();
        cacheManager.removeCache(this.config.getCacheName());
    }
}

