/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheProducer.class);
    private CacheConfiguration config;
    private Ehcache cache;

    public CacheProducer(Endpoint endpoint, CacheConfiguration config) throws Exception {
        super(endpoint);
        this.config = config;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public CacheEndpoint getEndpoint() {
        return (CacheEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        LOG.trace("Cache Name: {}", (Object)this.config.getCacheName());
        this.cache = this.getEndpoint().initializeCache();
        String key = (String)exchange.getIn().getHeader("CamelCacheKey", String.class);
        String operation = (String)exchange.getIn().getHeader("CamelCacheOperation", String.class);
        if (operation == null) {
            throw new CacheException("CamelCacheOperation header not specified in message");
        }
        if (key == null && !operation.equalsIgnoreCase("CamelCacheDeleteAll")) {
            throw new CacheException("CamelCacheKey is not specified in message header or endpoint URL.");
        }
        this.performCacheOperation(exchange, operation, key);
        exchange.getIn().removeHeader("CamelCacheKey");
        exchange.getIn().removeHeader("CamelCacheOperation");
    }

    private void performCacheOperation(Exchange exchange, String operation, String key) throws Exception {
        if (operation.equalsIgnoreCase("CamelCacheAdd")) {
            LOG.debug("Adding an element with key {} into the Cache", (Object)key);
            Object element = this.createElementFromBody(exchange, "CamelCacheAdd");
            this.cache.put(new Element((Object)key, element));
        } else if (operation.equalsIgnoreCase("CamelCacheUpdate")) {
            LOG.debug("Updating an element with key {} into the Cache", (Object)key);
            Object element = this.createElementFromBody(exchange, "CamelCacheUpdate");
            this.cache.put(new Element((Object)key, element));
        } else if (operation.equalsIgnoreCase("CamelCacheDeleteAll")) {
            LOG.debug("Deleting All elements from the Cache");
            this.cache.removeAll();
        } else if (operation.equalsIgnoreCase("CamelCacheDelete")) {
            LOG.debug("Deleting an element with key {} into the Cache", (Object)key);
            this.cache.remove((Serializable)((Object)key));
        } else if (operation.equalsIgnoreCase("CamelCacheGet")) {
            LOG.debug("Quering an element with key {} from the Cache", (Object)key);
            if (this.cache.isKeyInCache((Object)key) && this.cache.get((Serializable)((Object)key)) != null) {
                exchange.getIn().setHeader("CamelCacheElementWasFound", (Object)true);
                exchange.getIn().setBody((Object)this.cache.get((Serializable)((Object)key)).getValue());
            } else {
                exchange.getIn().removeHeader("CamelCacheElementWasFound");
            }
        } else if (operation.equalsIgnoreCase("CamelCacheCheck")) {
            LOG.debug("Querying an element with key {} from the Cache", (Object)key);
            if (this.cache.isKeyInCache((Object)key)) {
                exchange.getIn().setHeader("CamelCacheElementWasFound", (Object)true);
            } else {
                exchange.getIn().removeHeader("CamelCacheElementWasFound");
            }
        } else {
            throw new CacheException("CamelCacheOperation " + operation + " is not supported.");
        }
    }

    private Object createElementFromBody(Exchange exchange, String cacheOperation) throws NoTypeConversionAvailableException {
        Object element;
        Object body = exchange.getIn().getBody();
        if (body == null) {
            throw new CacheException("Body cannot be null for operation " + cacheOperation);
        }
        if (body instanceof Serializable) {
            element = body;
        } else {
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
            element = exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, (Object)is);
        }
        return element;
    }
}

