/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.component.cache.CacheEventListener;
import org.apache.camel.impl.DefaultConsumer;

public class CacheConsumer
extends DefaultConsumer {
    private CacheConfiguration config;

    public CacheConsumer(Endpoint endpoint, Processor processor, CacheConfiguration config) {
        super(endpoint, processor);
        this.config = config;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createConsumerCacheConnection();
    }

    public CacheEndpoint getEndpoint() {
        return (CacheEndpoint)super.getEndpoint();
    }

    protected void createConsumerCacheConnection() {
        CacheEventListener cacheEventListener = new CacheEventListener();
        cacheEventListener.setCacheConsumer(this);
        this.config.getEventListenerRegistry().addCacheEventListener(cacheEventListener);
        this.getEndpoint().initializeCache();
    }
}

