/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.castor;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.camel.Exchange;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;

public abstract class AbstractCastorDataFormat
implements DataFormat {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";
    private XMLContext xmlContext;
    private String mappingFile;
    private String[] classNames;
    private String[] packages;
    private boolean validation;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public AbstractCastorDataFormat() {
    }

    public AbstractCastorDataFormat(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.encoding);
        this.getMarshaller(exchange);
        Marshaller.marshal((Object)body, (Writer)writer);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        InputStreamReader reader = new InputStreamReader(inputStream);
        return this.getUnmarshaller(exchange).unmarshal((Reader)reader);
    }

    public XMLContext getXmlContext(ClassResolver resolver) throws Exception {
        if (this.xmlContext == null) {
            this.xmlContext = new XMLContext();
            if (ObjectHelper.isNotEmpty((Object)this.getMappingFile())) {
                Mapping xmlMap = new Mapping();
                xmlMap.loadMapping(resolver.loadResourceAsURL(this.getMappingFile()));
                this.xmlContext.addMapping(xmlMap);
            }
            if (this.getPackages() != null) {
                this.xmlContext.addPackages(this.getPackages());
            }
            if (this.getClassNames() != null) {
                for (String name : this.getClassNames()) {
                    Class clazz = resolver.resolveClass(name);
                    this.xmlContext.addClass(clazz);
                }
            }
        }
        return this.xmlContext;
    }

    public Unmarshaller getUnmarshaller(Exchange exchange) throws Exception {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.getXmlContext(exchange.getContext().getClassResolver()).createUnmarshaller();
            this.unmarshaller.setValidation(this.isValidation());
        }
        return this.unmarshaller;
    }

    public Marshaller getMarshaller(Exchange exchange) throws Exception {
        if (this.marshaller == null) {
            this.marshaller = this.getXmlContext(exchange.getContext().getClassResolver()).createMarshaller();
            this.marshaller.setValidation(this.isValidation());
        }
        return this.marshaller;
    }

    public void setXmlContext(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public void setClassNames(String[] classNames) {
        this.classNames = classNames;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }
}

