/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.cmis.CMISEndpoint;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CMISProducer.class);
    private final CMISSessionFacade cmisSessionFacade;

    public CMISProducer(CMISEndpoint endpoint, CMISSessionFacade cmisSessionFacade) {
        super((Endpoint)endpoint);
        this.cmisSessionFacade = cmisSessionFacade;
    }

    public void process(Exchange exchange) throws Exception {
        CmisObject cmisObject = this.createNode(exchange);
        LOG.debug("Created node with id: {}", (Object)cmisObject.getId());
        exchange.getOut().setBody((Object)cmisObject.getId());
    }

    private Map<String, Object> filterTypeProperties(Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(properties.size());
        String objectTypeName = "cmis:document";
        if (properties.containsKey("cmis:objectTypeId")) {
            objectTypeName = (String)properties.get("cmis:objectTypeId");
        }
        HashSet<String> types = new HashSet<String>();
        types.addAll(this.cmisSessionFacade.getPropertiesFor(objectTypeName));
        if (this.cmisSessionFacade.supportsSecondaries() && properties.containsKey("cmis:secondaryObjectTypeIds")) {
            Collection secondaryTypes = (Collection)properties.get("cmis:secondaryObjectTypeIds");
            for (String secondaryType : secondaryTypes) {
                types.addAll(this.cmisSessionFacade.getPropertiesFor(secondaryType));
            }
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!types.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private CmisObject createNode(Exchange exchange) throws Exception {
        this.validateRequiredHeader(exchange, "cmis:name");
        Message message = exchange.getIn();
        String parentFolderPath = this.parentFolderPathFor(message);
        Folder parentFolder = this.getFolderOnPath(exchange, parentFolderPath);
        Map<String, Object> cmisProperties = this.filterTypeProperties(message.getHeaders());
        if (this.isDocument(exchange)) {
            String fileName = (String)message.getHeader("cmis:name", String.class);
            String mimeType = this.getMimeType(message);
            byte[] buf = this.getBodyData(message);
            ContentStream contentStream = this.cmisSessionFacade.createContentStream(fileName, buf, mimeType);
            return this.storeDocument(parentFolder, cmisProperties, contentStream);
        }
        if (this.isFolder(message)) {
            return this.storeFolder(parentFolder, cmisProperties);
        }
        return this.storeDocument(parentFolder, cmisProperties, null);
    }

    private Folder getFolderOnPath(Exchange exchange, String path) {
        try {
            return (Folder)this.cmisSessionFacade.getObjectByPath(path);
        }
        catch (CmisObjectNotFoundException e) {
            throw new RuntimeExchangeException("Path not found " + path, exchange, (Throwable)e);
        }
    }

    private String parentFolderPathFor(Message message) {
        String customPath = (String)message.getHeader("CamelCMISFolderPath", String.class);
        if (customPath != null) {
            return customPath;
        }
        if (this.isFolder(message)) {
            String path = (String)message.getHeader("cmis:path");
            String name = (String)message.getHeader("cmis:name");
            if (path != null && path.length() > name.length()) {
                return path.substring(0, path.length() - name.length());
            }
        }
        return "/";
    }

    private boolean isFolder(Message message) {
        String baseTypeId = (String)message.getHeader("cmis:objectTypeId", String.class);
        if (baseTypeId != null) {
            return "cmis:folder".equals(this.cmisSessionFacade.getCMISTypeFor(baseTypeId));
        }
        return message.getBody() == null;
    }

    private Folder storeFolder(Folder parentFolder, Map<String, Object> cmisProperties) {
        if (!cmisProperties.containsKey("cmis:objectTypeId")) {
            cmisProperties.put("cmis:objectTypeId", "cmis:folder");
        }
        LOG.debug("Creating folder with properties: {}", cmisProperties);
        return parentFolder.createFolder(cmisProperties);
    }

    private Document storeDocument(Folder parentFolder, Map<String, Object> cmisProperties, ContentStream contentStream) {
        if (!cmisProperties.containsKey("cmis:objectTypeId")) {
            cmisProperties.put("cmis:objectTypeId", "cmis:document");
        }
        VersioningState versioningState = VersioningState.NONE;
        if (this.cmisSessionFacade.isObjectTypeVersionable((String)cmisProperties.get("cmis:objectTypeId"))) {
            versioningState = VersioningState.MAJOR;
        }
        LOG.debug("Creating document with properties: {}", cmisProperties);
        return parentFolder.createDocument(cmisProperties, contentStream, versioningState);
    }

    private void validateRequiredHeader(Exchange exchange, String name) throws NoSuchHeaderException {
        ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)name, String.class);
    }

    private boolean isDocument(Exchange exchange) {
        String baseTypeId = (String)exchange.getIn().getHeader("cmis:objectTypeId", String.class);
        if (baseTypeId != null) {
            return "cmis:document".equals(this.cmisSessionFacade.getCMISTypeFor(baseTypeId));
        }
        return exchange.getIn().getBody() != null;
    }

    private byte[] getBodyData(Message message) {
        return (byte[])message.getBody(byte[].class);
    }

    private String getMimeType(Message message) throws NoSuchHeaderException {
        String mimeType = (String)message.getHeader("cmis:contentStreamMimeType", String.class);
        if (mimeType == null) {
            mimeType = MessageHelper.getContentType((Message)message);
        }
        return mimeType;
    }
}

