/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.lang.reflect.Method;
import org.apache.camel.RuntimeCamelException;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionFactoryLocator {
    private static final Logger LOG = LoggerFactory.getLogger(SessionFactoryLocator.class);
    private static SessionFactory sessionFactory;

    private SessionFactoryLocator() {
    }

    public static void setSessionFactory(SessionFactory factory) {
        sessionFactory = factory;
    }

    public static SessionFactory getSessionFactory() {
        if (sessionFactory != null) {
            return sessionFactory;
        }
        sessionFactory = SessionFactoryLocator.loadSessionFactoryFromClassPath();
        return sessionFactory;
    }

    private static SessionFactory loadSessionFactoryFromClassPath() {
        try {
            Class<?> factoryClass = null;
            factoryClass = Class.forName("org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl");
            if (factoryClass != null) {
                Method method = factoryClass.getMethod("newInstance", new Class[0]);
                return (SessionFactory)method.invoke(null, new Object[0]);
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot create the SessionFactoryImpl due to: {0}", (Throwable)ex);
            throw new RuntimeCamelException((Throwable)ex);
        }
        return null;
    }
}

