/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import dojox.cometd.Bayeux;
import dojox.cometd.Client;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.BayeuxService;

public class CometdConsumer
extends DefaultConsumer
implements CometdProducerConsumer {
    private AbstractBayeux bayeux;
    private final CometdEndpoint endpoint;
    private ConsumerService service;

    public CometdConsumer(CometdEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void start() throws Exception {
        super.start();
        this.endpoint.connect(this);
        this.service = new ConsumerService(this.endpoint.getPath(), (Bayeux)this.bayeux, this);
    }

    public void stop() throws Exception {
        this.endpoint.disconnect(this);
        super.stop();
    }

    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }

    public CometdEndpoint getEndpoint() {
        return this.endpoint;
    }

    public static class ConsumerService
    extends BayeuxService {
        private final CometdEndpoint endpoint;
        private final CometdConsumer consumer;

        public ConsumerService(String channel, Bayeux bayeux, CometdConsumer consumer) {
            super(bayeux, channel);
            this.consumer = consumer;
            this.endpoint = consumer.getEndpoint();
            this.subscribe(channel, "push");
        }

        public void push(Client client, Object data) throws Exception {
            DefaultMessage message = new DefaultMessage();
            message.setBody(data);
            Exchange exchange = this.endpoint.createExchange();
            exchange.setIn((Message)message);
            this.consumer.getProcessor().process(exchange);
        }
    }
}

