/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.continuation.ContinuationCometdServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometdComponent
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(CometdComponent.class);
    private final Map<String, ConnectorRef> connectors = new HashMap<String, ConnectorRef>();
    private Server server;
    private String sslKeyPassword;
    private String sslPassword;
    private String sslKeystore;
    private SslSocketConnector sslSocketConnector;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties((Object)this, parameters);
        return new CometdEndpoint(this, uri, remaining, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(CometdProducerConsumer prodcon) throws Exception {
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "cometds".equals(endpoint.getProtocol()) ? this.getSslSocketConnector() : new SelectChannelConnector();
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getUri().getHost())) {
                    LOG.warn((Object)"You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                this.getServer().addConnector((Connector)connector);
                ContinuationCometdServlet servlet = this.createServletForConnector((Connector)connector, endpoint);
                connectorRef = new ConnectorRef((Connector)connector, servlet);
                this.getServer().start();
                this.connectors.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            AbstractBayeux bayeux = connectorRef.servlet.getBayeux();
            bayeux.setJSONCommented(endpoint.isJsonCommented());
            prodcon.setBayeux(bayeux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(CometdProducerConsumer prodcon) throws Exception {
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                this.getServer().removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    protected ContinuationCometdServlet createServletForConnector(Connector connector, CometdEndpoint endpoint) throws Exception {
        ContinuationCometdServlet servlet = new ContinuationCometdServlet();
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)servlet);
        if (endpoint.getBaseResource() != null) {
            String[] resources = endpoint.getBaseResource().split(":");
            LOG.debug((Object)(">>> Protocol found :" + resources[0] + ", and resource : " + resources[1]));
            if (resources[0].equals("file")) {
                context.setBaseResource(Resource.newResource((String)resources[1]));
            } else if (resources[0].equals("classpath")) {
                URL url = this.getCamelContext().getClassResolver().loadResourceAsURL(resources[1]);
                context.setBaseResource(Resource.newResource((URL)url));
            }
        }
        context.addServlet(holder, "/cometd/*");
        context.addServlet("org.eclipse.jetty.servlet.DefaultServlet", "/");
        holder.setInitParameter("timeout", Integer.toString(endpoint.getTimeout()));
        holder.setInitParameter("interval", Integer.toString(endpoint.getInterval()));
        holder.setInitParameter("maxInterval", Integer.toString(endpoint.getMaxInterval()));
        holder.setInitParameter("multiFrameInterval", Integer.toString(endpoint.getMultiFrameInterval()));
        holder.setInitParameter("JSONCommented", Boolean.toString(endpoint.isJsonCommented()));
        holder.setInitParameter("logLevel", Integer.toString(endpoint.getLogLevel()));
        return servlet;
    }

    public synchronized SslSocketConnector getSslSocketConnector() {
        if (this.sslSocketConnector == null) {
            this.sslSocketConnector = new SslSocketConnector();
            this.sslSocketConnector.setPassword(this.sslPassword);
            this.sslSocketConnector.setKeyPassword(this.sslKeyPassword);
            if (this.sslKeystore != null) {
                this.sslSocketConnector.setKeystore(this.sslKeystore);
            }
        }
        return this.sslSocketConnector;
    }

    public Server getServer() throws Exception {
        if (this.server == null) {
            this.server = this.createServer();
        }
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler((Handler)collection);
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        if (this.server != null) {
            this.server.stop();
        }
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    class ConnectorRef {
        Connector connector;
        ContinuationCometdServlet servlet;
        int refCount;

        public ConnectorRef(Connector connector, ContinuationCometdServlet servlet) {
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

