/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cometd.Client;
import org.cometd.server.AbstractBayeux;

public class CometdProducer
extends DefaultProducer
implements CometdProducerConsumer {
    private static final transient Log LOG = LogFactory.getLog(CometdProducer.class);
    private AbstractBayeux bayeux;
    private final CometdEndpoint endpoint;

    public CometdProducer(CometdEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void start() throws Exception {
        super.start();
        this.endpoint.connect(this);
    }

    public void stop() throws Exception {
        super.stop();
        this.endpoint.disconnect(this);
    }

    public void process(Exchange exchange) {
        ObjectHelper.notNull((Object)this.bayeux, (String)"bayeux");
        Collection clients = this.bayeux.getClients();
        for (Client client : clients) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delivering to client id: " + client.getId() + " path:" + this.endpoint.getPath() + " exchange: " + exchange));
            }
            client.deliver(client, this.endpoint.getPath(), exchange.getIn().getBody(), null);
        }
    }

    public CometdEndpoint getEndpoint() {
        return this.endpoint;
    }

    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }
}

