/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultProducer;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractService;
import org.cometd.server.BayeuxServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdProducer
extends DefaultProducer
implements CometdProducerConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CometdProducer.class);
    private BayeuxServerImpl bayeux;
    private ProducerService service;
    private final CometdEndpoint endpoint;

    public CometdProducer(CometdEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void start() throws Exception {
        super.start();
        this.endpoint.connect(this);
        this.service = new ProducerService((BayeuxServer)this.getBayeux(), this.endpoint.getPath(), this);
    }

    public void stop() throws Exception {
        super.stop();
        this.endpoint.disconnect(this);
    }

    public void process(Exchange exchange) {
        this.service.process(exchange);
    }

    @Override
    public CometdEndpoint getEndpoint() {
        return this.endpoint;
    }

    public BayeuxServerImpl getBayeux() {
        return this.bayeux;
    }

    @Override
    public void setBayeux(BayeuxServerImpl bayeux) {
        this.bayeux = bayeux;
    }

    public static class ProducerService
    extends AbstractService {
        private final CometdProducer producer;

        public ProducerService(BayeuxServer bayeux, String channel, CometdProducer producer) {
            super(bayeux, channel);
            this.producer = producer;
        }

        public void process(Exchange exchange) {
            String channelName = this.producer.getEndpoint().getPath();
            BayeuxServerImpl bayeux = this.producer.getBayeux();
            ServerChannel channel = bayeux.getChannel(channelName);
            ServerSession serverSession = this.getServerSession();
            if (channel != null) {
                this.logDelivery(exchange, channel);
                channel.publish((Session)serverSession, exchange.getIn().getBody(), null);
            }
        }

        private void logDelivery(Exchange exchange, ServerChannel channel) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Delivering to clients %s path: %s exchange: %s", channel.getSubscribers(), channel, exchange));
            }
        }
    }
}

