/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultComponent;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometdServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(CometdComponent.class);
    private final Map<String, ConnectorRef> connectors = new LinkedHashMap<String, ConnectorRef>();
    private String sslKeyPassword;
    private String sslPassword;
    private String sslKeystore;
    private SslSocketConnector sslSocketConnector;
    private SecurityPolicy securityPolicy;
    private List<BayeuxServer.Extension> extensions;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties((Object)this, parameters);
        return new CometdEndpoint(this, uri, remaining, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(CometdProducerConsumer prodcon) throws Exception {
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "cometds".equals(endpoint.getProtocol()) ? this.getSslSocketConnector() : new SelectChannelConnector();
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                Server server = this.createServer();
                server.addConnector((Connector)connector);
                CometdServlet servlet = this.createServletForConnector(server, (Connector)connector, endpoint);
                connectorRef = new ConnectorRef((Connector)connector, servlet, server);
                server.start();
                this.connectors.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            BayeuxServerImpl bayeux = connectorRef.servlet.getBayeux();
            if (this.securityPolicy != null) {
                bayeux.setSecurityPolicy(this.securityPolicy);
            }
            if (this.extensions != null) {
                for (BayeuxServer.Extension extension : this.extensions) {
                    bayeux.addExtension(extension);
                }
            }
            prodcon.setBayeux(bayeux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(CometdProducerConsumer prodcon) throws Exception {
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                connectorRef.server.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    protected CometdServlet createServletForConnector(Server server, Connector connector, CometdEndpoint endpoint) throws Exception {
        CometdServlet servlet = new CometdServlet();
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)servlet);
        holder.setAsyncSupported(true);
        if (endpoint.getBaseResource() != null) {
            String[] resources = endpoint.getBaseResource().split(":");
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> Protocol found: " + resources[0] + ", and resource: " + resources[1]);
            }
            if (resources[0].equals("file")) {
                context.setBaseResource(Resource.newResource((String)resources[1]));
            } else if (resources[0].equals("classpath")) {
                URL url = this.getCamelContext().getClassResolver().loadResourceAsURL(resources[1]);
                context.setBaseResource(Resource.newResource((URL)url));
            }
        }
        context.addServlet(holder, "/cometd/*");
        context.addServlet("org.eclipse.jetty.servlet.DefaultServlet", "/");
        context.setSessionHandler(new SessionHandler((SessionManager)new HashSessionManager()));
        holder.setInitParameter("timeout", Integer.toString(endpoint.getTimeout()));
        holder.setInitParameter("interval", Integer.toString(endpoint.getInterval()));
        holder.setInitParameter("maxInterval", Integer.toString(endpoint.getMaxInterval()));
        holder.setInitParameter("multiFrameInterval", Integer.toString(endpoint.getMultiFrameInterval()));
        holder.setInitParameter("JSONCommented", Boolean.toString(endpoint.isJsonCommented()));
        holder.setInitParameter("logLevel", Integer.toString(endpoint.getLogLevel()));
        return servlet;
    }

    public synchronized SslSocketConnector getSslSocketConnector() {
        if (this.sslSocketConnector == null) {
            this.sslSocketConnector = new SslSocketConnector();
            this.sslSocketConnector.getSslContextFactory().setKeyManagerPassword(this.sslPassword);
            this.sslSocketConnector.getSslContextFactory().setKeyStorePassword(this.sslKeyPassword);
            if (this.sslKeystore != null) {
                this.sslSocketConnector.getSslContextFactory().setKeyStore(this.sslKeystore);
            }
        }
        return this.sslSocketConnector;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public List<BayeuxServer.Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<BayeuxServer.Extension> extensions) {
        this.extensions = extensions;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<BayeuxServer.Extension>();
        }
        this.extensions.add(extension);
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler((Handler)collection);
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    class ConnectorRef {
        Connector connector;
        CometdServlet servlet;
        Server server;
        int refCount;

        public ConnectorRef(Connector connector, CometdServlet servlet, Server server) {
            this.connector = connector;
            this.servlet = servlet;
            this.server = server;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

