/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands.jolokia;

import org.apache.camel.util.ObjectHelper;
import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pAuthenticator;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JolokiaClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JolokiaClientFactory.class);

    private JolokiaClientFactory() {
    }

    public static J4pClient createJolokiaClient(String jolokiaUrl, String username, String password) {
        LOG.info("Creating jolokia client at URL: {}", (Object)jolokiaUrl);
        J4pClientBuilder builder = J4pClient.url((String)jolokiaUrl);
        boolean auth = false;
        if (ObjectHelper.isNotEmpty((Object)username)) {
            builder = builder.user(username);
            auth = true;
        }
        if (ObjectHelper.isNotEmpty((Object)password)) {
            builder = builder.password(password);
            auth = true;
        }
        if (auth) {
            builder = builder.authenticator((J4pAuthenticator)new BasicAuthenticator(true));
        }
        return builder.build();
    }
}

