/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

public final class HexUtils {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexUtils() {
    }

    public static String byteArrayToHexString(byte[] in, int start, int length) {
        String asHexString = null;
        if (in != null) {
            StringBuilder out = new StringBuilder(in.length * 2);
            for (int x = start; x < length; ++x) {
                int nybble = in[x] & 0xF0;
                out.append(hexChars[nybble >>>= 4]);
                out.append(hexChars[in[x] & 0xF]);
            }
            asHexString = out.toString();
        }
        return asHexString;
    }

    public static String byteArrayToHexString(byte[] in) {
        return HexUtils.byteArrayToHexString(in, 0, in.length);
    }

    public static byte[] hexToByteArray(String hexString) {
        StringBuilder normalize = new StringBuilder(hexString.length());
        for (int x = 0; x < hexString.length(); ++x) {
            char current = Character.toLowerCase(hexString.charAt(x));
            if (HexUtils.isHexChar(current)) {
                normalize.append(current);
                continue;
            }
            if (Character.isWhitespace(current)) continue;
            throw new IllegalStateException(String.format("Conversion of hex string to array failed. '%c' is not a valid hex character", Character.valueOf(current)));
        }
        if (normalize.length() % 2 > 0) {
            normalize.append('0');
        }
        byte[] hexArray = new byte[hexString.length() + 1 >> 1];
        for (int x = 0; x < hexArray.length; ++x) {
            int ni = x << 1;
            int mostSignificantNybble = Character.digit(normalize.charAt(ni), 16);
            int leastSignificantNybble = Character.digit(normalize.charAt(ni + 1), 16);
            int value = mostSignificantNybble << 4 | leastSignificantNybble & 0xF;
            hexArray[x] = (byte)value;
        }
        return hexArray;
    }

    public static boolean isHexChar(char current) {
        return Character.digit(current, 16) >= 0;
    }
}

