/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.converter.crypto.PGPPassphraseAccessor;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PGPDataFormatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PGPDataFormatUtil.class);

    private PGPDataFormatUtil() {
    }

    @Deprecated
    public static PGPPublicKey findPublicKey(CamelContext context, String filename, String userid, boolean forEncryption) throws IOException, PGPException, NoSuchProviderException {
        return PGPDataFormatUtil.findPublicKey(context, filename, null, userid, forEncryption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PGPPublicKey findPublicKey(CamelContext context, String filename, byte[] keyRing, String userid, boolean forEncryption) throws IOException, PGPException, NoSuchProviderException {
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, keyRing, forEncryption);
        try {
            List<PGPPublicKey> result = PGPDataFormatUtil.findPublicKeys(is, Collections.singletonList(userid), forEncryption);
            if (result.isEmpty()) {
                PGPPublicKey pGPPublicKey = null;
                return pGPPublicKey;
            }
            PGPPublicKey pGPPublicKey = result.get(0);
            return pGPPublicKey;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PGPPublicKey> findPublicKeys(CamelContext context, String filename, byte[] keyRing, List<String> userids, boolean forEncryption) throws IOException, PGPException, NoSuchProviderException {
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, keyRing, forEncryption);
        try {
            List<PGPPublicKey> list = PGPDataFormatUtil.findPublicKeys(is, userids, forEncryption);
            return list;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPPublicKey findPublicKeyWithKeyId(CamelContext context, String filename, byte[] keyRing, long keyid, boolean forEncryption) throws IOException, PGPException, NoSuchProviderException {
        PGPPublicKey pubKey;
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, keyRing, forEncryption);
        try {
            pubKey = PGPDataFormatUtil.findPublicKeyWithKeyId(is, keyid);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return pubKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPPrivateKey findPrivateKeyWithKeyId(CamelContext context, String filename, byte[] secretKeyRing, long keyid, String passphrase, PGPPassphraseAccessor passpraseAccessor, String provider) throws IOException, PGPException, NoSuchProviderException {
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, secretKeyRing, true);
        try {
            PGPPrivateKey pGPPrivateKey = PGPDataFormatUtil.findPrivateKeyWithKeyId(is, keyid, passphrase, passpraseAccessor, provider);
            return pGPPrivateKey;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    private static PGPPrivateKey findPrivateKeyWithKeyId(InputStream keyringInput, long keyid, String passphrase, PGPPassphraseAccessor passphraseAccessor, String provider) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyringInput));
        Iterator i = pgpSec.getKeyRings();
        while (i.hasNext()) {
            PGPPrivateKey privateKey;
            PGPSecretKeyRing keyring;
            PGPSecretKey secKey;
            Object data = i.next();
            if (!(data instanceof PGPSecretKeyRing) || (secKey = (keyring = (PGPSecretKeyRing)data).getSecretKey(keyid)) == null) continue;
            if (passphrase == null && passphraseAccessor != null) {
                Iterator userIDs = keyring.getSecretKey().getUserIDs();
                while (passphrase == null && userIDs.hasNext()) {
                    passphrase = passphraseAccessor.getPassphrase((String)userIDs.next());
                }
            }
            if (passphrase == null || (privateKey = secKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(passphrase.toCharArray()))) == null) continue;
            return privateKey;
        }
        return null;
    }

    private static InputStream determineKeyRingInputStream(CamelContext context, String filename, byte[] keyRing, boolean forEncryption) throws IOException {
        if (filename != null && keyRing != null) {
            String encryptionOrSignature = forEncryption ? "encryption" : "signature";
            throw new IllegalStateException(String.format("Either specify %s file name or key ring byte array. You can not specify both.", encryptionOrSignature));
        }
        InputStream is = keyRing != null ? new ByteArrayInputStream(keyRing) : ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)context.getClassResolver(), (String)filename);
        return is;
    }

    private static PGPPublicKey findPublicKeyWithKeyId(InputStream input, long keyid) throws IOException, PGPException, NoSuchProviderException {
        PGPPublicKeyRingCollection pgpSec = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input));
        Iterator keyRingIter = pgpSec.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            PGPPublicKey key = keyRing.getPublicKey(keyid);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    private static List<PGPPublicKey> findPublicKeys(InputStream input, List<String> userids, boolean forEncryption) throws IOException, PGPException, NoSuchProviderException {
        ArrayList<PGPPublicKey> result = new ArrayList<PGPPublicKey>(3);
        PGPPublicKeyRingCollection pgpSec = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input));
        Iterator keyRingIter = pgpSec.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            Set<String> keyUserIds = PGPDataFormatUtil.getUserIds(keyRing);
            Iterator keyIter = keyRing.getPublicKeys();
            while (keyIter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIter.next();
                for (String useridPart : userids) {
                    for (String keyUserId : keyUserIds) {
                        if (keyUserId == null || !keyUserId.contains(useridPart)) continue;
                        if (forEncryption) {
                            if (!PGPDataFormatUtil.isEncryptionKey(key)) continue;
                            LOG.debug("Public encryption key with key user ID {} and key ID {} found for specified user ID part {}", new Object[]{keyUserId, Long.toString(key.getKeyID()), useridPart});
                            result.add(key);
                            continue;
                        }
                        if (forEncryption || !PGPDataFormatUtil.isSignatureKey(key)) continue;
                        result.add(key);
                        LOG.debug("Public key with key user ID {} and key ID {} found for specified user ID part {}", new Object[]{keyUserId, Long.toString(key.getKeyID()), useridPart});
                    }
                }
            }
        }
        return result;
    }

    private static boolean isEncryptionKey(PGPPublicKey key) {
        if (!key.isEncryptionKey()) {
            return false;
        }
        Boolean hasEncryptionKeyFlags = PGPDataFormatUtil.hasOneOfExpectedKeyFlags(key, new int[]{4, 8});
        if (hasEncryptionKeyFlags != null && !hasEncryptionKeyFlags.booleanValue()) {
            LOG.debug("Public key with key key ID {} found for specified user ID. But this key will not be used for the encryption, because its key flags are not encryption key flags.", new Object[]{Long.toString(key.getKeyID())});
            return false;
        }
        return true;
    }

    private static Set<String> getUserIds(PGPPublicKeyRing keyRing) {
        LinkedHashSet<String> userIds = new LinkedHashSet<String>(3);
        Iterator keyIter = keyRing.getPublicKeys();
        while (keyIter.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)keyIter.next();
            Iterator iterator = key.getUserIDs();
            while (iterator.hasNext()) {
                userIds.add((String)iterator.next());
            }
        }
        return userIds;
    }

    private static Set<String> getUserIds(PGPSecretKeyRing keyRing) {
        LinkedHashSet<String> userIds = new LinkedHashSet<String>(3);
        PGPSecretKey key = keyRing.getSecretKey();
        Iterator iterator = key.getUserIDs();
        while (iterator.hasNext()) {
            userIds.add((String)iterator.next());
        }
        return userIds;
    }

    private static boolean isSignatureKey(PGPPublicKey key) {
        int algorithm = key.getAlgorithm();
        return algorithm == 1 || algorithm == 3 || algorithm == 17 || algorithm == 19 || algorithm == 20;
    }

    @Deprecated
    public static PGPPrivateKey findPrivateKey(CamelContext context, String keychainFilename, InputStream encryptedInput, String passphrase) throws IOException, PGPException, NoSuchProviderException {
        return PGPDataFormatUtil.findPrivateKey(context, keychainFilename, null, encryptedInput, passphrase, "BC");
    }

    @Deprecated
    public static PGPPrivateKey findPrivateKey(CamelContext context, String keychainFilename, byte[] secKeyRing, InputStream encryptedInput, String passphrase, String provider) throws IOException, PGPException, NoSuchProviderException {
        return PGPDataFormatUtil.findPrivateKey(context, keychainFilename, secKeyRing, encryptedInput, passphrase, null, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PGPPrivateKey findPrivateKey(CamelContext context, String keychainFilename, byte[] secKeyRing, InputStream encryptedInput, String passphrase, PGPPassphraseAccessor passphraseAccessor, String provider) throws IOException, PGPException, NoSuchProviderException {
        InputStream keyChainInputStream = PGPDataFormatUtil.determineKeyRingInputStream(context, keychainFilename, secKeyRing, true);
        PGPPrivateKey privKey = null;
        try {
            privKey = PGPDataFormatUtil.findPrivateKey(keyChainInputStream, encryptedInput, passphrase, passphraseAccessor, provider);
        }
        finally {
            IOHelper.close((Closeable)keyChainInputStream);
        }
        return privKey;
    }

    @Deprecated
    private static PGPPrivateKey findPrivateKey(InputStream keyringInput, InputStream encryptedInput, String passphrase, PGPPassphraseAccessor passphraseAccessor, String provider) throws IOException, PGPException, NoSuchProviderException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyringInput));
        PGPObjectFactory factory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)encryptedInput));
        Object o = factory.nextObject();
        if (o == null) {
            throw new PGPException("Provided input is not encrypted.");
        }
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)factory.nextObject();
        encryptedInput.reset();
        Iterator encryptedDataObjects = enc.getEncryptedDataObjects();
        PGPPrivateKey privateKey = null;
        PGPPublicKeyEncryptedData encryptedData = null;
        while (privateKey == null && encryptedDataObjects.hasNext()) {
            encryptedData = (PGPPublicKeyEncryptedData)encryptedDataObjects.next();
            PGPSecretKey pgpSecKey = pgpSec.getSecretKey(encryptedData.getKeyID());
            if (pgpSecKey == null) continue;
            if (passphrase == null && passphraseAccessor != null) {
                Iterator userIDs = pgpSecKey.getUserIDs();
                while (passphrase == null && userIDs.hasNext()) {
                    passphrase = passphraseAccessor.getPassphrase((String)userIDs.next());
                }
            }
            privateKey = pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(passphrase.toCharArray()));
        }
        if (privateKey == null && pgpSec.size() > 0 && encryptedData != null) {
            throw new PGPException("Provided input is encrypted with unknown pair of keys.");
        }
        return privateKey;
    }

    @Deprecated
    public static PGPSecretKey findSecretKey(CamelContext context, String keychainFilename, String passphrase) throws IOException, PGPException, NoSuchProviderException {
        return PGPDataFormatUtil.findSecretKey(context, keychainFilename, null, passphrase, "BC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PGPSecretKey findSecretKey(CamelContext context, String keychainFilename, byte[] secKeyRing, String passphrase, String userId, String provider) throws IOException, PGPException, NoSuchProviderException {
        InputStream keyChainInputStream = PGPDataFormatUtil.determineKeyRingInputStream(context, keychainFilename, secKeyRing, false);
        try {
            List<PGPSecretKeyAndPrivateKeyAndUserId> secKeys = PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(keyChainInputStream, Collections.singletonMap(userId, passphrase), provider);
            if (!secKeys.isEmpty()) {
                PGPSecretKey pGPSecretKey = secKeys.get(0).getSecretKey();
                return pGPSecretKey;
            }
            PGPSecretKey pGPSecretKey = null;
            return pGPSecretKey;
        }
        finally {
            IOHelper.close((Closeable)keyChainInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PGPSecretKeyAndPrivateKeyAndUserId> findSecretKeysWithPrivateKeyAndUserId(CamelContext context, String keychainFilename, byte[] secKeyRing, Map<String, String> sigKeyUserId2Password, String provider) throws IOException, PGPException, NoSuchProviderException {
        InputStream keyChainInputStream = PGPDataFormatUtil.determineKeyRingInputStream(context, keychainFilename, secKeyRing, false);
        try {
            List<PGPSecretKeyAndPrivateKeyAndUserId> list = PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(keyChainInputStream, sigKeyUserId2Password, provider);
            return list;
        }
        finally {
            IOHelper.close((Closeable)keyChainInputStream);
        }
    }

    @Deprecated
    public static PGPSecretKey findSecretKey(CamelContext context, String keychainFilename, byte[] secKeyRing, String passphrase, String provider) throws IOException, PGPException, NoSuchProviderException {
        return PGPDataFormatUtil.findSecretKey(context, keychainFilename, secKeyRing, passphrase, null, provider);
    }

    private static List<PGPSecretKeyAndPrivateKeyAndUserId> findSecretKeysWithPrivateKeyAndUserId(InputStream keyringInput, Map<String, String> sigKeyUserId2Password, String provider) throws IOException, PGPException, NoSuchProviderException {
        ArrayList<PGPSecretKeyAndPrivateKeyAndUserId> result = new ArrayList<PGPSecretKeyAndPrivateKeyAndUserId>(sigKeyUserId2Password.size());
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyringInput));
        Iterator i = pgpSec.getKeyRings();
        while (i.hasNext()) {
            Object data = i.next();
            if (!(data instanceof PGPSecretKeyRing)) continue;
            PGPSecretKeyRing keyring = (PGPSecretKeyRing)data;
            Set<String> keyUserIds = PGPDataFormatUtil.getUserIds(keyring);
            for (String userIdPart : sigKeyUserId2Password.keySet()) {
                for (String keyUserId : keyUserIds) {
                    if (!keyUserId.contains(userIdPart)) continue;
                    Iterator iterKey = keyring.getSecretKeys();
                    while (iterKey.hasNext()) {
                        PGPPrivateKey privateKey;
                        PGPSecretKey secKey = (PGPSecretKey)iterKey.next();
                        if (!PGPDataFormatUtil.isSigningKey(secKey) || (privateKey = secKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(sigKeyUserId2Password.get(userIdPart).toCharArray()))) == null) continue;
                        result.add(new PGPSecretKeyAndPrivateKeyAndUserId(secKey, privateKey, keyUserId));
                        LOG.debug("Private key with key user ID {} and key ID {} found for specified user ID part {}", new Object[]{keyUserId, Long.toString(privateKey.getKeyID()), userIdPart});
                    }
                }
            }
        }
        return result;
    }

    private static boolean isSigningKey(PGPSecretKey secKey) {
        if (!secKey.isSigningKey()) {
            return false;
        }
        Boolean hasSigningKeyFlag = PGPDataFormatUtil.hasOneOfExpectedKeyFlags(secKey.getPublicKey(), new int[]{2});
        if (hasSigningKeyFlag != null && !hasSigningKeyFlag.booleanValue()) {
            LOG.debug("Secret key with key ID {} found for specified user ID part. But this key will not be used for signing because of its key flags.", (Object)Long.toString(secKey.getKeyID()));
            return false;
        }
        return true;
    }

    private static Boolean hasOneOfExpectedKeyFlags(PGPPublicKey key, int[] expectedKeyFlags) {
        boolean containsKeyFlags = false;
        Iterator itsig = key.getSignatures();
        while (itsig.hasNext()) {
            PGPSignature sig = (PGPSignature)itsig.next();
            PGPSignatureSubpacketVector subPacks = sig.getHashedSubPackets();
            if (subPacks == null) continue;
            int keyFlag = subPacks.getKeyFlags();
            if (keyFlag > 0 && !containsKeyFlags) {
                containsKeyFlags = true;
            }
            for (int expectdKeyFlag : expectedKeyFlags) {
                int result = keyFlag & expectdKeyFlag;
                if (result != expectdKeyFlag) continue;
                return Boolean.TRUE;
            }
        }
        if (containsKeyFlags) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static class PGPSecretKeyAndPrivateKeyAndUserId {
        private final PGPSecretKey secretKey;
        private final PGPPrivateKey privateKey;
        private final String userId;

        public PGPSecretKeyAndPrivateKeyAndUserId(PGPSecretKey secretKey, PGPPrivateKey privateKey, String userId) {
            this.secretKey = secretKey;
            this.privateKey = privateKey;
            this.userId = userId;
        }

        public PGPSecretKey getSecretKey() {
            return this.secretKey;
        }

        public PGPPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getUserId() {
            return this.userId;
        }
    }
}

