/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;

public class DigitalSignatureConfiguration
implements Cloneable,
CamelContextAware {
    private PrivateKey privateKey;
    private KeyStore keystore;
    private SecureRandom secureRandom;
    private String algorithm = "DSA";
    private Integer bufferSize = 2048;
    private String provider;
    private String signatureHeaderName;
    private String alias;
    private char[] password;
    private PublicKey publicKey;
    private Certificate certificate;
    private CamelContext context;
    private String publicKeyName;
    private String certificateName;
    private String privateKeyName;
    private String keystoreName;
    private String randomName;
    private boolean clearHeaders;
    private String operation;

    public DigitalSignatureConfiguration copy() {
        try {
            return (DigitalSignatureConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
        this.setKeystore(this.keystoreName);
        this.setPublicKey(this.publicKeyName);
        this.setPrivateKey(this.privateKeyName);
        this.setCertificate(this.certificateName);
        this.setSecureRandom(this.randomName);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public PrivateKey getPrivateKey() throws Exception {
        return this.getPrivateKey(this.alias, this.password);
    }

    public PrivateKey getPrivateKey(String alias) throws Exception {
        return this.getPrivateKey(alias, this.password);
    }

    public PrivateKey getPrivateKey(String alias, char[] password) throws Exception {
        PrivateKey pk = null;
        if (alias != null && this.keystore != null) {
            pk = (PrivateKey)this.keystore.getKey(alias, password);
        }
        if (pk == null) {
            pk = this.privateKey;
        }
        return pk;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKey(String privateKeyName) {
        PrivateKey pk;
        if (this.context != null && privateKeyName != null && (pk = (PrivateKey)this.context.getRegistry().lookup(privateKeyName, PrivateKey.class)) != null) {
            this.setPrivateKey(pk);
        }
        if (privateKeyName != null) {
            this.privateKeyName = privateKeyName;
        }
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(String publicKeyName) {
        PublicKey pk;
        if (this.context != null && publicKeyName != null && (pk = (PublicKey)this.context.getRegistry().lookup(publicKeyName, PublicKey.class)) != null) {
            this.setPublicKey(pk);
        }
        if (publicKeyName != null) {
            this.publicKeyName = publicKeyName;
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Certificate getCertificate(String alias) throws Exception {
        Certificate cert = null;
        if (alias != null && this.keystore != null) {
            cert = this.keystore.getCertificate(alias);
        }
        if (cert == null) {
            cert = this.certificate;
        }
        return cert;
    }

    public Certificate getCertificate() throws Exception {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public void setCertificate(String certificateName) {
        Certificate certificate;
        if (this.context != null && certificateName != null && (certificate = (Certificate)this.context.getRegistry().lookup(certificateName, Certificate.class)) != null) {
            this.setCertificate(certificate);
        }
        if (certificateName != null) {
            this.certificateName = certificateName;
        }
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public void setKeystore(String keystoreName) {
        KeyStore keystore;
        if (this.context != null && keystoreName != null && (keystore = (KeyStore)this.context.getRegistry().lookup(keystoreName, KeyStore.class)) != null) {
            this.setKeystore(keystore);
        }
        if (keystoreName != null) {
            this.keystoreName = keystoreName;
        }
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(String randomName) {
        if (this.context != null && randomName != null) {
            SecureRandom random = (SecureRandom)this.context.getRegistry().lookup(randomName, SecureRandom.class);
            if (this.keystore != null) {
                this.setSecureRandom(random);
            }
        }
        if (randomName != null) {
            this.randomName = randomName;
        }
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSignatureHeader() {
        return this.signatureHeaderName != null ? this.signatureHeaderName : "CamelDigitalSignature";
    }

    public void setSignatureHeader(String signatureHeaderName) {
        this.signatureHeaderName = signatureHeaderName;
    }

    public boolean getClearHeaders() {
        return this.clearHeaders;
    }

    public void setClearHeaders(boolean clearHeaders) {
        this.clearHeaders = clearHeaders;
    }

    public void setCryptoOperation(String operation) {
        this.operation = operation;
    }

    public String getCryptoOperation() {
        return this.operation;
    }
}

